/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.dialogs;

import com.ibm.lab.soln.dialogs.StructureNewFolderWizardPage;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class StructureNewFileWizardPage
extends WizardNewFileCreationPage
implements SelectionListener {
    private boolean traceEnabled = true;
    private Button folderButton;
    private Button fileButton;
    private Button noneButton;
    private Button disablePage;
    private Composite resourceControl;
    private boolean nextPageExists;
    private IWizardPage nextPage = null;
    private boolean pastFirstEntry = false;
    private IStructuredSelection selection;
    private Wizard currentWizard;

    public StructureNewFileWizardPage(String pageName, IStructuredSelection selection, Wizard parent) {
        super(pageName, selection);
        this.selection = selection;
        this.currentWizard = parent;
        this.setDescription("Create a new file, or if you changed your mind, choose to ignore the page and choose another resource type.");
        this.setTitle("Project Structure: File Creation");
    }

    public boolean finish() {
        IFile newFile = null;
        if (!this.disablePage.getSelection()) {
            newFile = this.createNewFile();
            this.disablePage.setEnabled(false);
        }
        return newFile != null;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        composite.setLayout((Layout)layout);
        super.createControl(composite);
        this.resourceControl = (Composite)this.getControl();
        Label space1 = new Label(composite, 258);
        GridData data1 = new GridData(1808);
        space1.setLayoutData((Object)data1);
        this.disablePage = new Button(composite, 32);
        this.disablePage.setText("Select to ignore this resource creation page");
        this.disablePage.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (((Button)event.widget).getSelection()) {
                    StructureNewFileWizardPage.this.setPageComplete(true);
                } else {
                    StructureNewFileWizardPage.this.setPageComplete(StructureNewFileWizardPage.this.validatePage());
                }
                StructureNewFileWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Label labelT = new Label(composite, 0);
        labelT.setText("Note: Unless ignored, resource creation occurs as you page forward.");
        Label space2 = new Label(composite, 258);
        GridData data2 = new GridData(1808);
        space2.setLayoutData((Object)data2);
        this.createNextPageSelection(composite);
        this.setControl((Control)composite);
    }

    private void createNextPageSelection(Composite composite) {
        Group group = new Group(composite, 0);
        group.setText("Select Next Project Structure Page:");
        GridData gData = new GridData(768);
        group.setLayoutData((Object)gData);
        GridLayout gLayout = new GridLayout();
        gLayout.numColumns = 1;
        group.setLayout((Layout)gLayout);
        Label labelN = new Label((Composite)group, 0);
        labelN.setText("Select the resource to create next or none to stop:");
        this.folderButton = this.createRadioButton((Composite)group, "Create another fo&lder");
        this.fileButton = this.createRadioButton((Composite)group, "Create another f&ile");
        this.noneButton = this.createRadioButton((Composite)group, "N&o more Resources to create");
    }

    private Button createRadioButton(Composite parent, String label) {
        Button button = new Button(parent, 16400);
        button.setText(label);
        GridData data = new GridData(768);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.folderButton.getSelection()) {
            System.out.println("new folder request");
            this.nextPageExists = true;
        } else if (this.fileButton.getSelection()) {
            System.out.println("new file request");
            this.nextPageExists = true;
        } else if (this.noneButton.getSelection()) {
            System.out.println("no more request");
            this.nextPageExists = false;
        }
        this.validatePage();
        this.getWizard().getContainer().updateButtons();
    }

    public boolean canFlipToNextPage() {
        return this.nextPageExists;
    }

    public IWizardPage getNextPage() {
        System.out.println("In getNextPage");
        if (this.nextPage == null) {
            if (this.folderButton.getSelection()) {
                this.nextPage = new StructureNewFolderWizardPage("fold", this.selection, this.currentWizard);
            } else if (this.fileButton.getSelection()) {
                this.nextPage = new StructureNewFileWizardPage("file", this.selection, this.currentWizard);
            }
            this.currentWizard.addPage(this.nextPage);
            this.folderButton.setEnabled(false);
            this.fileButton.setEnabled(false);
            this.noneButton.setEnabled(false);
        }
        if (!this.disablePage.getSelection() && this.validatePage()) {
            this.resourceControl.setEnabled(false);
            if (this.finish()) {
                this.setDescription("Resource created");
            }
        }
        return super.getNextPage();
    }

    protected boolean validatePage() {
        if (this.disablePage != null && !this.disablePage.getSelection()) {
            return super.validatePage();
        }
        return true;
    }

    public void setVisible(boolean visible) {
        if (this.pastFirstEntry) {
            this.validatePage();
        }
        this.pastFirstEntry = true;
        super.setVisible(visible);
    }

    private void traceMsg(String msg) {
        System.out.println(msg);
    }
}

