/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.dialogs;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class DialogsPlugin
extends AbstractUIPlugin {
    private static DialogsPlugin plugin;
    private ResourceBundle resourceBundle;
    private boolean traceEnabled = false;

    public DialogsPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            this.resourceBundle = ResourceBundle.getBundle("com.ibm.lab.soln.dialogs.DialogsPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault("text_field_key", "myTextDefaultValue");
        store.setDefault("Recent_Edits_Limit", 8);
        store.setDefault("Recent_Edits_Persistence", true);
        this.traceMsg("set preference defaults");
    }

    public static DialogsPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = DialogsPlugin.getDefault().getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    private void traceMsg(String msg) {
        if (this.traceEnabled) {
            System.out.println(msg);
        }
    }

    public static class PreferenceListener {
        private static boolean hasPrefListener = false;
        private static IPropertyChangeListener prefStoreCL;
        private static Preferences.IPropertyChangeListener preferencesCL;
        private static boolean prefStore;

        static {
            prefStore = false;
        }

        public static boolean hasPrefListener() {
            return hasPrefListener;
        }

        public static void addListener() {
            if (prefStore) {
                PreferenceListener.addPrefStoreListener();
            } else {
                PreferenceListener.addPreferencesListener();
            }
            hasPrefListener = true;
            PreferenceListener.resultInformation("Add Property Change Listener Request", "Preferences change listener added. \nEach change made to a preference setting managed by the Dialogs plug-in will be reported.");
        }

        public static void addPreferencesListener() {
            preferencesCL = new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent event) {
                    PreferenceListener.resultInformation("<Got told something by a PreferenceStore object>", "Preference property: " + event.getProperty() + "\n\told setting: " + event.getOldValue() + "\n\tnew setting: " + event.getNewValue());
                }
            };
            DialogsPlugin.getDefault().getPluginPreferences().addPropertyChangeListener(preferencesCL);
        }

        public static void addPrefStoreListener() {
            prefStoreCL = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    PreferenceListener.resultInformation("<Got told something by a Preferences object>", "Preference property: " + event.getProperty() + "\n\told setting: " + event.getOldValue() + "\n\tnew setting: " + event.getNewValue());
                }
            };
            DialogsPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(prefStoreCL);
        }

        public static void removeListener() {
            if (prefStore) {
                DialogsPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(prefStoreCL);
            } else {
                DialogsPlugin.getDefault().getPluginPreferences().removePropertyChangeListener(preferencesCL);
            }
            hasPrefListener = false;
            PreferenceListener.resultInformation("Remove Property Change Listener Request", "Preferences change listener removed. ");
        }

        protected static void resultInformation(String title, String msg) {
            Shell shell = DialogsPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell();
            MessageDialog.openInformation((Shell)shell, (String)title, (String)msg);
        }
    }
}

