/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.contributions;

import java.util.StringTokenizer;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditor;

public class TextEditorWordCountAction
implements IEditorActionDelegate {
    static final String WORD_DELIMITERS = " .,'\"/?<>;:[]{}\\|`~!@#$%^&*()-_+=\n\r";
    TextEditor textEditor;

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.textEditor = (TextEditor)targetEditor;
    }

    public void run(IAction action) {
        int tokenCount;
        IDocument document = this.textEditor.getDocumentProvider().getDocument((Object)this.textEditor.getEditorInput());
        ITextSelection ts = (ITextSelection)this.textEditor.getSelectionProvider().getSelection();
        try {
            String text = document.get(ts.getOffset(), ts.getLength());
            tokenCount = new StringTokenizer(text, WORD_DELIMITERS).countTokens();
        }
        catch (BadLocationException badLocationException) {
            tokenCount = 0;
        }
        MessageDialog.openInformation(null, (String)"Word Count", (String)("Number of words: " + tokenCount));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (selection != null && selection instanceof ITextSelection) {
            ITextSelection ts = (ITextSelection)selection;
            if (ts.getLength() == 0) {
                System.out.println("TextEditorWordCountAction disabled");
                action.setEnabled(false);
            } else {
                System.out.println("TextEditorWordCountAction enabled");
                action.setEnabled(true);
            }
        } else {
            System.out.println("TextEditorWordCountAction disabled");
            action.setEnabled(false);
        }
    }
}

