/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.interopedit.editors;

import com.ibm.lab.soln.interopedit.ActiveXEditorImages;
import com.ibm.lab.soln.interopedit.editors.ActiveXHTMLEditor;
import com.ibm.lab.soln.interopedit.editors.ActiveXWebBrowser;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;

public class ActiveXMultiPageEditorContributor
extends MultiPageEditorActionBarContributor {
    private Action boldAction;
    private Action italicAction;
    private Action underlineAction;
    private IEditorPart activeEditorPart;
    private ActiveXHTMLEditor activeXeditor = null;
    private ActiveXWebBrowser activeBrowser;

    public ActiveXMultiPageEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void setActivePage(IEditorPart part) {
        if (this.activeEditorPart == part) {
            return;
        }
        this.activeEditorPart = part;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            ITextEditor editor = part instanceof ITextEditor ? (ITextEditor)part : null;
            actionBars.setGlobalActionHandler("delete", this.getAction(editor, "delete"));
            actionBars.setGlobalActionHandler("undo", this.getAction(editor, "undo"));
            actionBars.setGlobalActionHandler("redo", this.getAction(editor, "redo"));
            actionBars.setGlobalActionHandler("cut", this.getAction(editor, "cut"));
            actionBars.setGlobalActionHandler("copy", this.getAction(editor, "copy"));
            actionBars.setGlobalActionHandler("paste", this.getAction(editor, "paste"));
            actionBars.setGlobalActionHandler("selectAll", this.getAction(editor, "selectAll"));
            actionBars.setGlobalActionHandler("find", this.getAction(editor, "find"));
            actionBars.setGlobalActionHandler("bookmark", this.getAction(editor, "bookmark"));
            actionBars.updateActionBars();
        }
    }

    private void createActions() {
        this.boldAction = new Action(){

            public void run() {
                if (ActiveXMultiPageEditorContributor.this.activeXeditor != null) {
                    ActiveXMultiPageEditorContributor.this.activeBrowser.docExecCommand("Bold");
                }
            }
        };
        this.boldAction.setText("Bold");
        this.boldAction.setToolTipText("Toggle bold text.");
        this.boldAction.setImageDescriptor(ActiveXEditorImages.EDITOR_BOLD_IMAGE);
        this.boldAction.setDisabledImageDescriptor(ActiveXEditorImages.EDITOR_BOLD__DISABLED_IMAGE);
        this.italicAction = new Action(){

            public void run() {
                if (ActiveXMultiPageEditorContributor.this.activeXeditor != null) {
                    ActiveXMultiPageEditorContributor.this.activeBrowser.docExecCommand("Italic");
                }
            }
        };
        this.italicAction.setText("Italic");
        this.italicAction.setToolTipText("Toggle Italic Text");
        this.italicAction.setImageDescriptor(ActiveXEditorImages.EDITOR_ITALIC_IMAGE);
        this.italicAction.setDisabledImageDescriptor(ActiveXEditorImages.EDITOR_ITALIC_DISABLED_IMAGE);
        this.underlineAction = new Action(){

            public void run() {
                if (ActiveXMultiPageEditorContributor.this.activeXeditor != null) {
                    ActiveXMultiPageEditorContributor.this.activeBrowser.docExecCommand("Underline");
                }
            }
        };
        this.underlineAction.setText("Underline");
        this.underlineAction.setToolTipText("Toggle Underline TExt");
        this.underlineAction.setImageDescriptor(ActiveXEditorImages.EDITOR_UNDERLINE_IMAGE);
        this.underlineAction.setDisabledImageDescriptor(ActiveXEditorImages.EDITOR_UNDERLINE_DISABLED_IMAGE);
    }

    public void contributeToMenu(IMenuManager manager) {
        MenuManager menu = new MenuManager("Soln:IE HTML Editor");
        manager.prependToGroup("additions", (IContributionItem)menu);
        menu.add((IAction)this.boldAction);
        menu.add((IAction)this.italicAction);
        menu.add((IAction)this.underlineAction);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.boldAction);
        manager.add((IAction)this.italicAction);
        manager.add((IAction)this.underlineAction);
    }

    public void init(IActionBars bars, IWorkbenchPage page) {
        super.init(bars, page);
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        super.setActiveEditor(targetEditor);
        this.activeXeditor = null;
        if (targetEditor instanceof ActiveXHTMLEditor) {
            this.activeXeditor = (ActiveXHTMLEditor)targetEditor;
        }
        this.activeBrowser = this.activeXeditor.getBrowser();
    }
}

