/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.interopedit.editors;

import com.ibm.lab.soln.interopedit.editors.ActiveXBrowserView;
import com.ibm.lab.soln.interopedit.editors.ActiveXWebBrowser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;

public class ActiveXHTMLEditor
extends MultiPageEditorPart {
    public static final String EDITOR_LABEL = "Soln:IE HTML Editor";
    private TextEditor editor;
    private ActiveXWebBrowser webBrowser;
    private ActiveXBrowserView webBrowserView;
    private String fileLoc;
    private static String FILE_PREFIX = "file:///";
    private boolean browserPartIsDirty = false;

    protected void createPages() {
        this.createActiveXPage();
        this.createEditorPage();
        IEditorInput input = this.editor.getEditorInput();
        if (input instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            IFile file = fileInput.getFile();
            this.fileLoc = String.valueOf(FILE_PREFIX) + file.getLocation().toString();
            if (this.webBrowser != null) {
                this.webBrowser.Navigate(this.fileLoc);
                this.webBrowser.setDesignModeProperty("On");
                this.webBrowser.docExecCommand("2D-Position");
                this.webBrowser.docExecCommand("LiveResize");
                this.webBrowser.docExecCommand("MultipleSelection");
            }
        }
    }

    private void createActiveXPage() {
        Composite composite = new Composite(this.getContainer(), 0);
        this.webBrowserView = new ActiveXBrowserView();
        this.webBrowser = this.webBrowserView.createBrowserPartControl(composite);
        int index = this.addPage((Control)composite);
        this.setPageText(index, EDITOR_LABEL);
    }

    private void createEditorPage() {
        try {
            this.editor = new TextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, this.editor.getTitle());
        }
        catch (PartInitException e) {
            ErrorDialog.openError((Shell)this.getSite().getShell(), (String)"Error creating nested text editor", null, (IStatus)e.getStatus());
        }
    }

    public void doSave(IProgressMonitor monitor) {
        this.getEditor(1).doSave(monitor);
    }

    public void doSaveAs() {
        IEditorPart editor = this.getEditor(1);
        editor.doSaveAs();
        this.setPageText(0, editor.getTitle());
        this.setInput(editor.getEditorInput());
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (!(input instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, input);
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        if (newPageIndex == 1) {
            this.resetEditorText();
        } else {
            this.resetBrowserText();
        }
    }

    private void resetBrowserText() {
        String editorText = this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).get();
        this.webBrowser.replace(editorText);
    }

    private void resetEditorText() {
        this.editor.getDocumentProvider().getDocument((Object)this.editor.getEditorInput()).set(this.webBrowser.getinnerHTML());
    }

    public ActiveXWebBrowser getBrowser() {
        return this.webBrowser;
    }

    public boolean isDirty() {
        return this.webBrowser != null;
    }
}

