/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources.nature_builder;

import com.ibm.lab.soln.resources.EDUResourcesPlugin;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class NewProjectWizard
extends Wizard
implements INewWizard {
    private WizardNewProjectCreationPage mainPage;
    private IProject newProject;
    private boolean traceEnabled = false;

    public void addPages() {
        this.mainPage = new WizardNewProjectCreationPage("MyProjNewPage");
        this.mainPage.setDescription("Create a new project with CustomNature.\n CustomNature adds ReadmeBuilder.");
        this.mainPage.setTitle("New Custom Project");
        this.addPage((IWizardPage)this.mainPage);
    }

    public IProject getNewProject() {
        return this.newProject;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public boolean performFinish() {
        this.createNewProject();
        return true;
    }

    public IProject createNewProject() {
        IPath newPath;
        if (this.newProject != null) {
            return this.newProject;
        }
        final IProject newProjectHandle = this.mainPage.getProjectHandle();
        IPath defaultPath = Platform.getLocation();
        if (defaultPath.equals((Object)(newPath = this.mainPage.getLocationPath()))) {
            newPath = null;
        }
        IWorkspace workspace = EDUResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                NewProjectWizard.this.createProject(description, newProjectHandle, monitor);
                NewProjectWizard.this.addCustomNature(newProjectHandle);
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            this.resultError("Create Project with CustomNature Request", "Project creation failed");
            e.printStackTrace();
            return null;
        }
        this.newProject = newProjectHandle;
        return this.newProject;
    }

    public void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            monitor.done();
            throw throwable;
        }
        Object var4_6 = null;
        monitor.done();
    }

    public void addCustomNature(IProject project) throws CoreException {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "com.ibm.lab.soln.resources.customnature";
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
            this.resultInformation("Create Project with CustomNature Request", "CustomNature added to the " + project.getName() + " project.");
        }
        catch (CoreException e) {
            this.resultError("Create Project with CustomNature Request", "Adding CustomNature to project " + project.getName() + " failed");
            e.printStackTrace();
        }
    }

    void traceMsg(String msg) {
        if (this.traceEnabled) {
            System.out.println(msg);
        }
    }

    protected void resultInformation(String title, String msg) {
        if (this.traceEnabled) {
            System.out.println(String.valueOf(title) + msg);
        } else {
            MessageDialog.openInformation((Shell)this.getShell(), (String)title, (String)msg);
        }
    }

    protected void resultError(String title, String msg) {
        if (this.traceEnabled) {
            System.out.println(String.valueOf(title) + msg);
        } else {
            MessageDialog.openError((Shell)this.getShell(), (String)title, (String)msg);
        }
    }
}

