/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources.nature_builder;

import com.ibm.lab.soln.resources.ActionResourceAction;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;

public class ActionRemoveBuilderFromProject
extends ActionResourceAction {
    public void run(IAction action) {
        IProject project = (IProject)this.selection.iterator().next();
        try {
            this.removeFromBuildSpec(project);
        }
        catch (CoreException e) {
            e.printStackTrace();
            this.resultError("Soln: Resource - Remove ReadmeBuilder Request", "Error removing the ReadmeBuilder from the project.");
        }
    }

    public void removeFromBuildSpec(IProject project) throws CoreException {
        IProjectDescription desp = project.getDescription();
        ICommand[] commands = desp.getBuildSpec();
        boolean found = false;
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("com.ibm.lab.soln.resources.readmebuilder")) {
                found = true;
                break;
            }
            ++i;
        }
        if (found) {
            ICommand[] newCommands = new ICommand[commands.length - 1];
            System.arraycopy(commands, 1, newCommands, 0, commands.length - 1);
            desp.setBuildSpec(newCommands);
            project.setDescription(desp, null);
            this.resultInformation("Soln: Resource - Remove ReadmeBuilder Request", "ReadmeBuilder was removed.");
        }
    }
}

