/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resources;

import com.ibm.lab.soln.resources.EDUResourcesPlugin;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.ISaveContext;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class WorkspaceSaveParticipant
implements ISaveParticipant {
    private boolean traceEnabled = true;
    String wspMode = "WkSavePart -> Save Count:";
    int wspCount = 0;

    public WorkspaceSaveParticipant() {
        this.traceMsg(" *----------> MyWorkSpaceSaveParticipant created.", null);
    }

    public void doneSaving(ISaveContext context) {
        this.traceMsg(" *----------> doneSaving ", context);
    }

    public void prepareToSave(ISaveContext context) throws CoreException {
        ++this.wspCount;
        this.traceMsg(" *----------> prepareToSave ", context);
    }

    public void rollback(ISaveContext context) {
        this.traceMsg(" *----------> rollback ", context);
    }

    public void saveFile(File f) throws CoreException {
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {}
    }

    public void saving(ISaveContext context) throws CoreException {
        EDUResourcesPlugin plugin = EDUResourcesPlugin.getDefault();
        int saveNumber = context.getSaveNumber();
        String saveFileName = "save-" + Integer.toString(saveNumber);
        this.traceMsg(" *----------> saving - Save File Name: " + saveFileName, context);
        File f = plugin.getStateLocation().append(saveFileName).toFile();
        this.saveFile(f);
        context.map((IPath)new Path("save"), (IPath)new Path(saveFileName));
        context.needSaveNumber();
        context.needDelta();
    }

    void traceMsg(String msg, ISaveContext context) {
        if (this.traceEnabled) {
            System.out.println(String.valueOf(this.wspMode) + this.wspCount + msg);
        }
        if (context != null) {
            switch (context.getKind()) {
                case 1: {
                    System.out.println("ISaveContext.FULL_SAVE");
                    break;
                }
                case 2: {
                    System.out.println("ISaveContext.SNAPSHOT");
                    break;
                }
                case 3: {
                    System.out.println("ISaveContext.PROJECT_SAVE");
                    break;
                }
            }
        }
    }
}

