/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.msseditor.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;

public class MiniSpreadsheetWizardNewFileCreationPage
extends WizardNewFileCreationPage {
    private IWorkbench workbench;
    private int rowCount = 10;
    private int columnCount = 4;
    private Text rowText;
    private Text columnText;
    private boolean initialized = false;
    private static int nameCounter = 1;

    public MiniSpreadsheetWizardNewFileCreationPage(IWorkbench workbench, IStructuredSelection selection) {
        super("MiniSpreadsheetWizardNewFileCreationPage", selection);
        this.setTitle("Folder, Name and Dimensions");
        this.setFileName("sample" + nameCounter + ".mss");
        this.workbench = workbench;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        Group group = new Group((Composite)this.getControl(), 0);
        group.setLayoutData((Object)new GridData(1808));
        group.setText("Dimensions");
        group.setLayout((Layout)new FormLayout());
        Label rowLabel = new Label((Composite)group, 16384);
        rowLabel.setText("Rows");
        this.rowText = new Text((Composite)group, 2052);
        this.rowText.setText(Integer.toString(this.rowCount));
        this.rowText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MiniSpreadsheetWizardNewFileCreationPage.this.handleEvent(null);
            }
        });
        Label columnLabel = new Label((Composite)group, 16384);
        columnLabel.setText("Columns");
        this.columnText = new Text((Composite)group, 2052);
        this.columnText.setText(Integer.toString(this.columnCount));
        FormData data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.top = new FormAttachment(0, 10);
        rowLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(30, 0);
        data.top = new FormAttachment(0, 10);
        data.width = 100;
        this.rowText.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.top = new FormAttachment((Control)rowLabel, 10, -1);
        columnLabel.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment((Control)this.rowText, 0, 16384);
        data.top = new FormAttachment((Control)rowLabel, 10, -1);
        data.width = 100;
        this.columnText.setLayoutData((Object)data);
        this.columnText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MiniSpreadsheetWizardNewFileCreationPage.this.handleEvent(null);
            }
        });
        Label separator = new Label((Composite)group, 16384);
        data = new FormData();
        data.left = new FormAttachment(0, 10);
        data.top = new FormAttachment((Control)this.columnText, 10, -1);
        data.height = 10;
        separator.setLayoutData((Object)data);
        this.initialized = true;
    }

    public boolean finish() {
        IFile newFile = this.createNewFile();
        if (newFile == null) {
            return false;
        }
        try {
            IWorkbenchPage page = this.workbench.getActiveWorkbenchWindow().getActivePage();
            if (page != null) {
                page.openEditor(newFile);
            }
        }
        catch (PartInitException partInitException) {
            return false;
        }
        ++nameCounter;
        return true;
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
        if (this.initialized) {
            if (this.isPageComplete()) {
                this.validateFileName();
            }
            if (this.isPageComplete()) {
                this.validateDimensions();
            }
        }
    }

    private void validateFileName() {
        String filename = this.getFileName();
        Path path = new Path(filename);
        if (path.getFileExtension() == null || !path.getFileExtension().toLowerCase().equals("mss")) {
            this.setPageComplete(false);
            this.setErrorMessage("Extension must be 'mss'");
        } else {
            this.setPageComplete(true);
        }
    }

    private void validateDimensions() {
        try {
            this.rowCount = Integer.parseInt(this.rowText.getText());
            this.columnCount = Integer.parseInt(this.columnText.getText());
            this.setPageComplete(true);
        }
        catch (NumberFormatException numberFormatException) {
            this.setPageComplete(false);
            this.setErrorMessage("Invalid number.");
            return;
        }
        if (this.columnCount > 10) {
            this.setPageComplete(false);
            this.setErrorMessage(MessageFormat.format("Maximum number of columns is {0}.", Integer.toString(10)));
            return;
        }
        if (this.columnCount < 0 || this.rowCount < 0) {
            this.setPageComplete(false);
            this.setErrorMessage("Invalid number of rows or columns.");
            return;
        }
        if (this.columnCount < 1) {
            this.setPageComplete(false);
            this.setErrorMessage("Must have a minimum of one column.");
            return;
        }
    }

    protected InputStream getInitialContents() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.rowCount) {
            int j = 0;
            while (j < this.columnCount) {
                sb.append(";");
                ++j;
            }
            sb.append("\n");
            ++i;
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }
}

