/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.msseditor.ui.actions;

import com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetEditor;
import com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetImages;
import com.ibm.lab.soln.msseditor.ui.actions.MiniSpreadsheetEditorAction;

public class ChangeAlignmentAction
extends MiniSpreadsheetEditorAction {
    int alignment;
    ChangeAlignmentAction[] group;

    public ChangeAlignmentAction(String id, int newAlignment) {
        this.alignment = newAlignment;
        this.setId(id);
        if (newAlignment == 16384) {
            this.setToolTipText("Align All Left");
            this.setImageDescriptor(MiniSpreadsheetImages.IMAGE_ALIGN_LEFT);
        } else if (newAlignment == 0x1000000) {
            this.setToolTipText("Align All Center");
            this.setImageDescriptor(MiniSpreadsheetImages.IMAGE_ALIGN_CENTER);
        } else {
            this.setToolTipText("Align All Right");
            this.setImageDescriptor(MiniSpreadsheetImages.IMAGE_ALIGN_RIGHT);
        }
    }

    public int getStyle() {
        return 2;
    }

    public void run() {
        this.editor.setAlignment(this.alignment);
        this.update();
    }

    private void update() {
        int i = 0;
        while (i < this.group.length) {
            this.group[i].setChecked(this.editor.getDefaultAlignment() == this.group[i].alignment);
            ++i;
        }
    }

    public void setActiveEditor(MiniSpreadsheetEditor editor) {
        super.setActiveEditor(editor);
        this.update();
    }

    public void setGroup(ChangeAlignmentAction[] group) {
        this.group = group;
    }
}

