/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.msseditor.ui;

import com.ibm.lab.soln.msseditor.core.IMiniSpreadsheetListener;
import com.ibm.lab.soln.msseditor.core.MiniSpreadsheet;
import com.ibm.lab.soln.msseditor.core.MiniSpreadsheetRow;
import com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetContentProvider;
import com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetLabelProvider;
import com.ibm.lab.soln.msseditor.ui.MiniSpreadsheetUIPlugin;
import com.ibm.lab.soln.msseditor.ui.actions.AppendRowAction;
import com.ibm.lab.soln.msseditor.ui.actions.RemoveRowAction;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class MiniSpreadsheetEditor
extends EditorPart
implements IMiniSpreadsheetListener,
IResourceChangeListener {
    private TableViewer tableViewer;
    private Table table;
    private MiniSpreadsheet miniSpreadsheet = new MiniSpreadsheet(10, 4);
    private boolean isDirty = false;
    static final String STD_HEADINGS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int defaultAlignment;
    private Menu contextMenu;

    public void createPartControl(Composite parent) {
        this.createTable(parent);
        this.tableViewer = new TableViewer(this.table);
        this.getSite().setSelectionProvider((ISelectionProvider)this.tableViewer);
        this.initializeTableLayout(parent);
        this.createColumns();
        this.initializeCellEditors();
        this.createContextMenu();
        this.tableViewer.setContentProvider((IContentProvider)new MiniSpreadsheetContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new MiniSpreadsheetLabelProvider());
        this.tableViewer.setInput((Object)this.miniSpreadsheet);
    }

    public void initializeTableLayout(Composite parent) {
        parent.setLayout((Layout)new FormLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0, 5);
        formData.right = new FormAttachment(100, -5);
        formData.top = new FormAttachment(0, 5);
        formData.bottom = new FormAttachment(100, -5);
        this.table.setLayoutData((Object)formData);
    }

    private void initializeCellEditors() {
        int columnCount = this.table.getColumnCount();
        CellEditor[] editors = new CellEditor[columnCount];
        String[] properties = new String[columnCount];
        int i = 1;
        while (i < columnCount) {
            properties[i] = Integer.toString(i);
            editors[i] = new TextCellEditor((Composite)this.table);
            ++i;
        }
        this.tableViewer.setColumnProperties(properties);
        this.tableViewer.setCellEditors(editors);
        this.tableViewer.setCellModifier(new ICellModifier(){

            public void modify(Object element, String property, Object value) {
                MiniSpreadsheetRow msr = element instanceof Item ? (MiniSpreadsheetRow)((Item)element).getData() : (MiniSpreadsheetRow)element;
                int columnIndex = Integer.parseInt(property) - 1;
                MiniSpreadsheetEditor.this.miniSpreadsheet.setData(msr.getRowIndex(), columnIndex, (String)value);
            }

            public boolean canModify(Object element, String property) {
                return true;
            }

            public Object getValue(Object element, String property) {
                MiniSpreadsheetRow msr = (MiniSpreadsheetRow)element;
                int columnIndex = Integer.parseInt(property) - 1;
                return msr.getString(columnIndex);
            }
        });
    }

    private void createTable(Composite parent) {
        this.table = new Table(parent, 66306);
        this.table.setLinesVisible(true);
    }

    private void createColumns() {
        TableLayout layout = new TableLayout();
        this.table.setLayout((Layout)layout);
        this.table.setHeaderVisible(true);
        TableColumn rn = new TableColumn(this.table, 0);
        rn.setResizable(false);
        rn.setAlignment(0x1000000);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 40, false));
        int i = 0;
        while (i < this.miniSpreadsheet.getColumnCount()) {
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10));
            TableColumn tc = new TableColumn(this.table, 0);
            if (i < STD_HEADINGS.length()) {
                tc.setText(new Character(STD_HEADINGS.charAt(i)).toString());
            } else {
                tc.setText(Integer.toString(i + 1));
            }
            final TableColumn tc2 = tc;
            tc2.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MiniSpreadsheetEditor.this.table.setRedraw(false);
                    MiniSpreadsheetEditor.this.table.setHeaderVisible(false);
                    if (tc2.getAlignment() == 16384) {
                        tc2.setAlignment(0x1000000);
                    } else if (tc2.getAlignment() == 0x1000000) {
                        tc2.setAlignment(131072);
                    } else {
                        tc2.setAlignment(16384);
                    }
                    MiniSpreadsheetEditor.this.table.setHeaderVisible(true);
                    MiniSpreadsheetEditor.this.table.setRedraw(true);
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            ++i;
        }
        this.setAlignment(0x1000000);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager(this.getEditorSite().getId(), this.getSite().getId());
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                MiniSpreadsheetEditor.this.fillContextMenu(manager);
            }
        });
        Menu contextMenu = menuMgr.createContextMenu((Control)this.table);
        this.table.setMenu(contextMenu);
        this.getSite().registerContextMenu(menuMgr, this.getSite().getSelectionProvider());
    }

    private void fillContextMenu(IMenuManager menuMgr) {
        AppendRowAction appendRowAction = new AppendRowAction();
        appendRowAction.setActiveEditor(this);
        menuMgr.add((IAction)appendRowAction);
        menuMgr.add((IContributionItem)new GroupMarker("additions"));
        RemoveRowAction removeRowAction = new RemoveRowAction();
        removeRowAction.setActiveEditor(this);
        menuMgr.add((IAction)removeRowAction);
    }

    public void setFocus() {
        this.table.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.getEditorInput() instanceof IFileEditorInput) {
                IFile file = ((IFileEditorInput)this.getEditorInput()).getFile();
                if (file.exists()) {
                    this.saveContents(file);
                } else {
                    this.doSaveAs(MessageFormat.format("The original file ''{0}'' has been deleted.", file.getName()));
                }
            } else {
                this.doSaveAs();
            }
        }
        catch (CoreException e) {
            monitor.setCanceled(true);
            MessageDialog.openError(null, (String)"Unable to Save Changes", (String)e.getLocalizedMessage());
            return;
        }
    }

    public void doSaveAs() {
        this.doSaveAs(null);
    }

    private void doSaveAs(String message) {
        try {
            IFile file = this.createNewFile(message);
            if (file != null) {
                this.saveContents(file);
                this.setTitle(file.getName());
                this.setInput((IEditorInput)new FileEditorInput(file));
                this.firePropertyChange(258);
            }
        }
        catch (CoreException e) {
            MessageDialog.openError(null, (String)"Unable to Save Changes", (String)e.getLocalizedMessage());
            return;
        }
    }

    private IFile createNewFile(String message) throws CoreException {
        SaveAsDialog dialog = new SaveAsDialog(this.getEditorSite().getShell());
        dialog.setTitle("Save Mini-Spreadsheet As");
        if (this.getEditorInput() instanceof FileEditorInput) {
            dialog.setOriginalFile(((FileEditorInput)this.getEditorInput()).getFile());
        }
        dialog.create();
        dialog.setMessage("Save file to another location.");
        if (message != null) {
            dialog.setMessage(message, 2);
        }
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return null;
        }
        String ext = path.getFileExtension();
        if (ext == null || !ext.equalsIgnoreCase("mss")) {
            throw new CoreException((IStatus)new Status(4, MiniSpreadsheetUIPlugin.getId(), 0, "File extension must be 'mss'.", null));
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(new byte[0]), false, null);
        }
        return file;
    }

    public void gotoMarker(IMarker marker) {
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IStorageEditorInput)) {
            throw new PartInitException("Invalid Input");
        }
        this.init(site, (IStorageEditorInput)editorInput);
    }

    protected void init(IEditorSite site, IStorageEditorInput editorInput) throws PartInitException {
        try {
            this.setContents(editorInput);
            this.setSite((IWorkbenchPartSite)site);
            this.setInput((IEditorInput)editorInput);
            this.setTitle(editorInput.getName());
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        }
        catch (CoreException e) {
            throw new PartInitException(e.getMessage());
        }
    }

    protected void setContents(IStorageEditorInput sei) throws CoreException {
        InputStream is = sei.getStorage().getContents();
        this.miniSpreadsheet.removeMiniSpreadsheetListener(this);
        this.miniSpreadsheet = new MiniSpreadsheet(is);
        this.setIsDirty(false);
        this.miniSpreadsheet.addMiniSpreadsheetListener(this);
    }

    public void valueChanged(MiniSpreadsheet miniSpreadsheet, int row, int column, String newValue) {
        this.setIsDirty(true);
    }

    public void rowsChanged(MiniSpreadsheet miniSpreadsheet) {
        this.setIsDirty(true);
    }

    private void saveContents(IFile file) throws CoreException {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        try {
            this.miniSpreadsheet.save(file);
            this.setIsDirty(false);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            throw throwable;
        }
        Object var2_4 = null;
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void setIsDirty(boolean isDirty) {
        this.isDirty = isDirty;
        this.firePropertyChange(257);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setAlignment(int alignment) {
        TableColumn[] tcs = this.table.getColumns();
        int i = 0;
        while (i < tcs.length) {
            tcs[i].setAlignment(alignment);
            ++i;
        }
        this.defaultAlignment = alignment;
        this.table.redraw();
    }

    public int getDefaultAlignment() {
        return this.defaultAlignment;
    }

    public MiniSpreadsheet getMiniSpreadsheet() {
        return this.miniSpreadsheet;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        if (!(this.getEditorInput() instanceof FileEditorInput)) {
            return;
        }
        if (event.getType() == 1) {
            final IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
            IResourceDelta delta = event.getDelta().findMember(file.getFullPath());
            if (delta != null) {
                if (delta.getKind() == 2) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            MiniSpreadsheetEditor.this.setIsDirty(true);
                        }
                    });
                }
                if (delta.getKind() == 4 && (delta.getFlags() & 0x40100) != 0) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            try {
                                MiniSpreadsheetEditor.this.miniSpreadsheet.load(file.getContents());
                                MiniSpreadsheetEditor.this.setIsDirty(false);
                            }
                            catch (CoreException coreException) {
                                MiniSpreadsheetEditor.this.setIsDirty(true);
                            }
                        }
                    });
                }
            }
        }
    }

    public void dispose() {
        super.dispose();
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }
}

