/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.msseditor.core;

import com.ibm.lab.soln.msseditor.core.MiniSpreadsheet;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;

public class MiniSpreadsheetRow
implements IAdaptable {
    private String[] data;
    private int rowIndex;
    private MiniSpreadsheet miniSpreadsheet;

    public MiniSpreadsheetRow(MiniSpreadsheet mss, int columnCount, int rowIndex) {
        this.data = new String[columnCount];
        int i = 0;
        while (i < columnCount) {
            this.data[i] = new String();
            ++i;
        }
        this.rowIndex = rowIndex;
        this.miniSpreadsheet = mss;
    }

    public String getString(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.data.length) {
            return "";
        }
        return this.data[columnIndex];
    }

    public int getInt(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.data.length) {
            return 0;
        }
        try {
            return Integer.parseInt(this.data[columnIndex]);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public boolean isInt(int columnIndex) {
        if (columnIndex < 0 || columnIndex >= this.data.length) {
            return false;
        }
        if (this.data[columnIndex].length() == 0) {
            return false;
        }
        try {
            Integer.parseInt(this.data[columnIndex]);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    public boolean hasInts() {
        int i = 0;
        while (i < this.data.length) {
            if (this.isInt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setData(int columnIndex, String value) {
        if (columnIndex < 0 || columnIndex >= this.data.length) {
            return;
        }
        value.replace(';', '_');
        this.data[columnIndex] = value;
        this.miniSpreadsheet.fireCellChanged(this.rowIndex, columnIndex, value);
    }

    public void setData(int columnIndex, int value) {
        if (columnIndex < 0 || columnIndex >= this.data.length) {
            return;
        }
        this.data[columnIndex] = Integer.toString(value);
        this.miniSpreadsheet.fireCellChanged(this.rowIndex, columnIndex, this.data[columnIndex]);
    }

    public int getColumnCount() {
        return this.data.length;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void remove() {
        this.miniSpreadsheet.removeRow(this);
    }

    void setRowIndex(int i) {
        this.rowIndex = i;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }
}

