/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.lab.soln.resourceview;

import com.ibm.lab.soln.jface.JFaceComponent;
import com.ibm.lab.soln.resourceview.ViewPlugin;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;

public class ResourceView
extends ViewPart
implements ISelectionListener {
    private JFaceComponent jcomp;
    private Action action1;
    private Action action2;
    private Action doubleClickAction;
    private ResourceFilter filter = new ResourceFilter();

    public void createPartControl(Composite parent) {
        this.jcomp = this.createJFaceComponent(parent);
        this.jcomp.configureViewer();
        this.jcomp.setInput((Object)ViewPlugin.getWorkspace().getRoot());
        this.processViewerSelection();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.jcomp.getViewer());
        this.getSite().getPage().addSelectionListener("org.eclipse.ui.views.ResourceNavigator", (ISelectionListener)this);
        this.makeActions((StructuredViewer)this.jcomp.getViewer());
        this.hookContextMenu((StructuredViewer)this.jcomp.getViewer());
        this.hookDoubleClickAction((StructuredViewer)this.jcomp.getViewer());
        this.contributeToActionBars();
        this.jcomp.getViewer().setSorter((ViewerSorter)new ResourceSorter());
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        System.out.println("View heard outside selection " + selection);
        IStructuredSelection ssel = (IStructuredSelection)selection;
        if (ssel.getFirstElement() instanceof IContainer) {
            this.jcomp.setInput((Object)((IContainer)ssel.getFirstElement()));
        } else {
            this.jcomp.setInput((Object)ViewPlugin.getWorkspace().getRoot());
        }
    }

    private void processViewerSelection() {
        this.jcomp.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                System.out.println(">View hears selection" + event.getSelection());
                IStructuredSelection ssel = (IStructuredSelection)event.getSelection();
                IStatusLineManager status = ResourceView.this.getViewSite().getActionBars().getStatusLineManager();
                if (ssel != null && ssel.getFirstElement() instanceof IResource) {
                    IResource res = (IResource)ssel.getFirstElement();
                    status.setMessage(res.getLocation().toString());
                } else {
                    status.setMessage(null);
                }
                status.update(false);
            }
        });
    }

    private void makeActions(final StructuredViewer viewer) {
        this.action1 = new Action(){

            public void run() {
                ResourceView.this.showMessage(viewer, "Action 1 executed");
            }
        };
        this.action1.setText("Action 1");
        this.action1.setToolTipText("Action 1 tooltip");
        this.action1.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_INFO_TSK"));
        this.action2 = new Action("Action 2", 8){

            public void run() {
                if (this.isChecked()) {
                    viewer.addFilter((ViewerFilter)ResourceView.this.filter);
                } else {
                    viewer.removeFilter((ViewerFilter)ResourceView.this.filter);
                }
            }
        };
        this.action2.setToolTipText("Action 2 tooltip");
        this.action2.setChecked(false);
        this.action2.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJS_TASK_TSK"));
        this.doubleClickAction = new Action(){

            public void run() {
                ISelection selection = viewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                ResourceView.this.showMessage(viewer, "Double-click detected on " + obj.toString());
            }
        };
    }

    private void showMessage(StructuredViewer viewer, String message) {
        MessageDialog.openInformation((Shell)viewer.getControl().getShell(), (String)"Sample View", (String)message);
    }

    private void hookContextMenu(StructuredViewer viewer) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add((IAction)ResourceView.this.action1);
                manager.add((IAction)ResourceView.this.action2);
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        Menu menu = menuMgr.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        IMenuManager manager1 = bars.getMenuManager();
        manager1.add((IAction)this.action1);
        manager1.add((IContributionItem)new Separator());
        manager1.add((IAction)this.action2);
        IToolBarManager manager = bars.getToolBarManager();
        manager.add((IAction)this.action1);
        manager.add((IAction)this.action2);
    }

    private void hookDoubleClickAction(StructuredViewer viewer) {
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ResourceView.this.doubleClickAction.run();
            }
        });
    }

    private JFaceComponent createJFaceComponent(Composite composite) {
        String opt = new String("2");
        if (opt.equals("1")) {
            JFaceComponent jfaceComp = new JFaceComponent(composite);
            return jfaceComp;
        }
        Table table = this.createTableControl(composite);
        JFaceComponent jfaceComp = new JFaceComponent(table);
        return jfaceComp;
    }

    private Table createTableControl(Composite parent) {
        Table table = new Table(parent, 66306);
        table.setLinesVisible(true);
        TableLayout layout = new TableLayout();
        table.setLayout((Layout)layout);
        table.setHeaderVisible(true);
        String[] STD_HEADINGS = new String[]{"Resource Name", "Resource Data"};
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(5, 40, true));
        TableColumn tc0 = new TableColumn(table, 0);
        tc0.setText(STD_HEADINGS[0]);
        tc0.setAlignment(16384);
        tc0.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(10, true));
        TableColumn tc1 = new TableColumn(table, 0);
        tc1.setText(STD_HEADINGS[1]);
        tc1.setAlignment(16384);
        tc1.setResizable(true);
        return table;
    }

    public void setFocus() {
    }

    public class ResourceSorter
    extends ViewerSorter {
        int dotted_cat = 0;
        int container_cat = 1;
        int file_cat = 2;

        public int category(Object element) {
            if (element instanceof IContainer) {
                return this.container_cat;
            }
            IFile file = (IFile)element;
            if (file.getName().startsWith(".")) {
                return this.dotted_cat;
            }
            return this.file_cat;
        }
    }

    public class ResourceFilter
    extends ViewerFilter {
        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                return !file.getName().startsWith(".");
            }
            return true;
        }
    }
}

