// (C) Copyright David James Pearce and James Noble 2005. Permission 
// to copy, use, modify, sell and distribute this software is granted 
// provided this copyright notice appears in all copies. This 
// software is provided "as is" without express or implied warranty, 
// and with no claim as to its suitability for any purpose.
//
// Email: david.pearce@mcs.vuw.ac.nz

package ral.util;

import ral.internal.*;
import ral.base.*;
import java.util.*;

public abstract aspect StaticRel<FROM,TO,T extends Pair<FROM,TO> > implements Relationship<FROM,TO,T> {

 interface Rel<X,Y> {}
			
 declare parents : TO implements Rel<FROM,TO>; 
 declare parents : FROM implements Rel<FROM,TO>;
	
 public HashSet<Pair<X,Y>> Rel.rel = new HashSet<Pair<X,Y>>();

 public boolean add(T a) {
  Rel f = (Rel) a.from();
  Rel t = (Rel) a.to();

  f.rel.add(a);
  return t.rel.add(a);		
 }

 public boolean remove(T t) { return false; }

 public T get(FROM f, TO t) {
  // hack for the moment 
  Rel r = (Rel) f;
  HashSet<T> hs = (HashSet<T>) r.rel;
  for(T x : hs) {
   if(x.to().equals(t)) {
    return x;	    
  }}
  return null;
 }

 public ImmutableHashSetAdaptor<T> toAssoc(TO t) { return  new ImmutableHashSetAdaptor<T>(((Rel)t).rel); }	
 public ImmutableHashSetAdaptor<T> fromAssoc(FROM f) { return new ImmutableHashSetAdaptor<T>(((Rel)f).rel); }		

 public ImmutableHashSetAdaptor<FROM> to(TO t) { return null; }	
 public ImmutableHashSetAdaptor<TO> from(FROM f) { return null; }
}
