// (C) Copyright David James Pearce and James Noble 2005. Permission 
// to copy, use, modify, sell and distribute this software is granted 
// provided this copyright notice appears in all copies. This 
// software is provided "as is" without express or implied warranty, 
// and with no claim as to its suitability for any purpose.
//
// Email: david.pearce@mcs.vuw.ac.nz

package ral.util;

import ral.base.*;
import ral.internal.*;
import java.util.*;

abstract public aspect SimpleStaticRel<FROM,TO> implements SimpleRelationship<FROM,TO> {
	interface Fwd<X> {}
	interface Bwd<Y> {}
		
	declare parents : TO implements Bwd<FROM>; 
	declare parents : FROM implements Fwd<TO>;
	
	final public HashSet<X> Fwd.fwd = new HashSet<X>();
	final public HashSet<Y> Bwd.bwd = new HashSet<Y>();

	public boolean add(FROM _f, TO _t) {
	 Fwd f = (Fwd) _f;
	 Bwd t = (Bwd) _t;

         f.fwd.add(_t);
	 return t.bwd.add(_f);		
	}


	public boolean add(FixedPair<FROM,TO> x) { return add(x.from(),x.to()); }
	public boolean remove(FixedPair<FROM,TO> x) { return remove(x.from(),x.to()); }
	public boolean remove(FROM _f, TO _t) {	return false; }

        public FixedPair<FROM,TO> get(FROM f, TO t) {
	 return new FixedPair<FROM,TO>(f,t);
        }

	public HashSet<FixedPair<FROM,TO>> toAssoc(TO t) {
	   return null;
        }
    
        public HashSet<FixedPair<FROM,TO>> fromAssoc(FROM f) {
	   return null;
        }		

	public ImmutableHashSetAdaptor<FROM> to(TO t) { return  new ImmutableHashSetAdaptor<FROM>(((Bwd)t).bwd); }	
	public ImmutableHashSetAdaptor<TO> from(FROM f) { return new ImmutableHashSetAdaptor<TO>(((Fwd)f).fwd); }		
}
