// (C) Copyright David James Pearce and James Noble 2005. Permission 
// to copy, use, modify, sell and distribute this software is granted 
// provided this copyright notice appears in all copies. This 
// software is provided "as is" without express or implied warranty, 
// and with no claim as to its suitability for any purpose.
//
// Email: david.pearce@mcs.vuw.ac.nz

package ral.util;

import java.util.*;

import ral.base.*;
import ral.internal.*;

public class SimpleHashRel<FROM,TO> implements SimpleRelationship<FROM,TO> {
    final private HashMap<FROM,HashSet<TO>> _fwd;
    final private HashMap<TO,HashSet<FROM>> _bwd;
    
    public SimpleHashRel() {
	_fwd = new HashMap<FROM,HashSet<TO>>();
	_bwd = new HashMap<TO,HashSet<FROM>>();
    }
    
    public SimpleHashRel(Collection<? extends Pair<FROM,TO>> r) {
	throw new RuntimeException("not implemented");
    }

    public boolean add(FixedPair<FROM,TO> a) { 
	return add(a.from(),a.to());
    }

    public FixedPair<FROM,TO> get(FROM f, TO t) {
	return new FixedPair<FROM,TO>(f,t);
    }

    public boolean add(FROM f, TO t) {
	HashSet<TO> ts = _fwd.get(f);
	HashSet<FROM> fs = _bwd.get(t);
	
	if(ts == null) { 
	    ts = new HashSet<TO>(); 
	    _fwd.put(f,ts);
	}

	if(fs == null) { 
	    fs = new HashSet<FROM>();
	    _bwd.put(t,fs);
	}

	fs.add(f);
	return ts.add(t);
    }
    
    public boolean remove(FixedPair<FROM,TO> a) {
	return remove(a.from(),a.to());
    }

    public boolean remove(FROM f, TO t) {
	return false;
    }

    public HashSet<FixedPair<FROM,TO>> toAssoc(TO t) {
	return null;
    }
    
    public HashSet<FixedPair<FROM,TO>> fromAssoc(FROM f) {
	return null;
    }		

    public ImmutableHashSetAdaptor<FROM> to(TO t) {
	HashSet<FROM> fs = _bwd.get(t);
	
	if(fs == null) { 
	    fs = new HashSet<FROM>();
	    _bwd.put(t,fs);
	}
	
	return new ImmutableHashSetAdaptor(fs);
    }

    public ImmutableHashSetAdaptor<TO> from(FROM f) {
	HashSet<TO> ts = _fwd.get(f);
	
	if(ts == null) { 
	    ts = new HashSet<TO>();
	    _fwd.put(f,ts);
	}
	
	return new ImmutableHashSetAdaptor(ts);
    }

    /*
    // Adaptors
    private final class SetAdaptor implements Set<Assoc<FROM,TO>> {	
	private HashSet<Assoc<FROM,TO>> _set;
	public SetAdaptor(HashSet<Assoc<FROM,TO>> s) { _set = s; }    
	
	public Iterator<Assoc<FROM,TO>> iterator() { 
	    // this probably won't work, since iterator.remove will break the relationship
	    return _set.iterator();
	}    
	
	public boolean add(Assoc<FROM,TO> o) { return HashMapRelation.this.add(o); }
	public boolean addAll(Collection<? extends Assoc<FROM,TO>> c) { throw new RuntimeException("not supported"); }
	
	public void clear() { 
	    throw new RuntimeException("not supported");
	}
	public boolean contains(Object o) { return _set.contains(o); }
	public boolean containsAll(Collection<?> c) { return _set.containsAll(c); }
	public boolean equals(Object o) { return _set.equals(o); }
	public int hashCode() { return _set.hashCode(); }
	public boolean isEmpty() { return _set.isEmpty(); }
	
	public boolean remove(Object o) { 
	    return HashMapRelation.this.remove((Assoc<FROM,TO>) o);
	}
	
	public boolean removeAll(Collection<?> c) { throw new RuntimeException("not supported"); }
	public boolean retainAll(Collection<?> c) { throw new RuntimeException("not supported"); }

	public int size() { return _set.size(); }

	public Object[] toArray() { return _set.toArray(); }
	public <T> T[] toArray(T[] a) { return _set.toArray(a); }
    }
    */
}
