// (C) Copyright David James Pearce and James Noble 2005. Permission 
// to copy, use, modify, sell and distribute this software is granted 
// provided this copyright notice appears in all copies. This 
// software is provided "as is" without express or implied warranty, 
// and with no claim as to its suitability for any purpose.
//
// Email: david.pearce@mcs.vuw.ac.nz

package ral.util;

import java.util.*;

import ral.base.*;
import ral.internal.*;

public class HashRel<FROM,TO,T extends Pair<FROM,TO>> implements Relationship<FROM,TO,T> {
    final private HashMap<FROM,HashSet<T>> _fwd;
    final private HashMap<TO,HashSet<T>> _bwd;
    
    public HashRel() {
	_fwd = new HashMap<FROM,HashSet<T>>();
	_bwd = new HashMap<TO,HashSet<T>>();
    }
    
    public HashRel(Collection<? extends T> r) {
	throw new RuntimeException("not implemented");
    }

    public boolean add(T a) { 
	HashSet<T> ts = _fwd.get(a.from());
	HashSet<T> fs = _bwd.get(a.to());
	
	if(ts == null) { 
	    ts = new HashSet<T>(); 
	    _fwd.put(a.from(),ts);
	}

	if(fs == null) { 
	    fs = new HashSet<T>();
	    _bwd.put(a.to(),fs);
	}

	fs.add(a);
	return ts.add(a);
    }

    public T get(FROM f, TO t) {
	// hack for the moment 
	HashSet<T> fs = _bwd.get(t);
	for(T x : fs) {
	    if(x.from().equals(f)) {
		return x;	    
	    }
	}
	return null;
    }

    public boolean remove(T a) {
	return false;
    }

    public ImmutableHashSetAdaptor<T> toAssoc(TO t) {
	HashSet<T> fs = _bwd.get(t);
	
	if(fs == null) { 
	    fs = new HashSet<T>();
	    _bwd.put(t,fs);
	}
	
	return new ImmutableHashSetAdaptor(fs);
    }
    
    public ImmutableHashSetAdaptor<T> fromAssoc(FROM f) {
	HashSet<T> ts = _fwd.get(f);
	
	if(ts == null) { 
	    ts = new HashSet<T>();
	    _fwd.put(f,ts);
	}
	
	return new ImmutableHashSetAdaptor(ts);
    }		

    public HashSet<FROM> to(TO t) {
	return null;
    }

    public HashSet<TO> from(FROM t) {
	return null;
    }

    /*
    // Adaptors
    private final class SetAdaptor implements Set<Assoc<FROM,TO>> {	
	private HashSet<Assoc<FROM,TO>> _set;
	public SetAdaptor(HashSet<Assoc<FROM,TO>> s) { _set = s; }    
	
	public Iterator<Assoc<FROM,TO>> iterator() { 
	    // this probably won't work, since iterator.remove will break the relationship
	    return _set.iterator();
	}    
	
	public boolean add(Assoc<FROM,TO> o) { return HashRelation.this.add(o); }
	public boolean addAll(Collection<? extends Assoc<FROM,TO>> c) { throw new RuntimeException("not supported"); }
	
	public void clear() { 
	    throw new RuntimeException("not supported");
	}
	public boolean contains(Object o) { return _set.contains(o); }
	public boolean containsAll(Collection<?> c) { return _set.containsAll(c); }
	public boolean equals(Object o) { return _set.equals(o); }
	public int hashCode() { return _set.hashCode(); }
	public boolean isEmpty() { return _set.isEmpty(); }
	
	public boolean remove(Object o) { 
	    return HashRelation.this.remove((Assoc<FROM,TO>) o);
	}
	
	public boolean removeAll(Collection<?> c) { throw new RuntimeException("not supported"); }
	public boolean retainAll(Collection<?> c) { throw new RuntimeException("not supported"); }

	public int size() { return _set.size(); }

	public Object[] toArray() { return _set.toArray(); }
	public <T> T[] toArray(T[] a) { return _set.toArray(a); }
    }
    */
}
