// (C) Copyright David James Pearce and James Noble 2005. Permission 
// to copy, use, modify, sell and distribute this software is granted 
// provided this copyright notice appears in all copies. This 
// software is provided "as is" without express or implied warranty, 
// and with no claim as to its suitability for any purpose.
//
// Email: david.pearce@mcs.vuw.ac.nz

package ral.internal;

import java.util.*;

public class ImmutableHashSetAdaptor<T> extends AbstractSet<T> {
    private final HashSet<T> _set;
    public ImmutableHashSetAdaptor(HashSet<T> s) { _set = s; }    
    public Iterator<T> iterator() { return _set.iterator(); }    
    public int size() { return _set.size(); }
}
