// (C) Copyright David James Pearce and James Noble 2005. Permission 
// to copy, use, modify, sell and distribute this software is granted 
// provided this copyright notice appears in all copies. This 
// software is provided "as is" without express or implied warranty, 
// and with no claim as to its suitability for any purpose.
//
// Email: david.pearce@mcs.vuw.ac.nz

package ral.base;
import java.util.*;

public interface UniMultiRelationship<FROM,TO,T extends Pair<FROM,TO>> {
    public boolean add(T t);	
    public boolean remove(T t);
    public T get(FROM f, TO t);

    public Collection<T> fromAssoc(FROM t);
    public Collection<TO> from(FROM f);
}
