// (C) Copyright David James Pearce and James Noble 2005. Permission 
// to copy, use, modify, sell and distribute this software is granted 
// provided this copyright notice appears in all copies. This 
// software is provided "as is" without express or implied warranty, 
// and with no claim as to its suitability for any purpose.
//
// Email: david.pearce@mcs.vuw.ac.nz

package ral.base;

public class Pair<FROM,TO> {
    final private FROM _from;
    final private TO _to;
    
    public Pair(FROM x, TO y) {
	_from = x;
	_to = y;
    }
    
    final public FROM from() { return _from; }
    final public TO to() { return _to; }

    final public int hashCode() {
	return _from.hashCode() ^ _to.hashCode();
    }

    final public boolean equals(Object o) {
	Pair<FROM,TO> x = (Pair<FROM,TO>) o;
	return x._to == _to && x._from == _from;
    }
}
