import ral.base.*;
import ral.util.*;

public class Benchmark {

    static int total = 0;

    static class Result {
	public long createTime;
	public long addTime;
	public long traverseTime;
	public Result(long c, long a, long t) {
	    createTime = c;
	    addTime = a;
	    traverseTime = t;
	}
    }

    public static long doAdd(SimpleRelationship<Student,Course> r, Student[] students, Course[] courses) {
	long start = System.currentTimeMillis();

	for(int j=0;j!=500000;++j) {
	    int s = (int) (Math.random() * students.length);		
	    int c = (int) (Math.random() * courses.length);
	    r.add(students[s],courses[c]);
	}
	
	long end = System.currentTimeMillis();

	return end-start;
    }


    public static long doTraverse(SimpleRelationship<Student,Course> r, Student[] students, Course[] courses) {
	long start = System.currentTimeMillis();

	for(Student s : students) {
	    for(Course c : r.from(s)) {
		for(Student s2 : r.to(c)) {
			total = total + 1;
		}
	    } 
	}

	long end = System.currentTimeMillis();

	return end-start;
    }

    public static Result doTest() {
	Student students[] = new Student[100000];
	Course courses[] = new Course[20000];
	
	for(int s = 0; s!=students.length;++s) {
	    students[s] = new Student("Student #" + Integer.toString(s));
	}
	
	for(int s = 0; s!=courses.length;++s) {
	    courses[s] = new Course("Course #" + Integer.toString(s), "A lecturer");
	}
	SimpleRelationship<Student,Course> r;

	//r = Attends.aspectOf();
	r = new SimpleHashRel<Student,Course>();

	long at = doAdd(r,students,courses);
	long tt = doTraverse(r,students,courses);
	return new Result(0,at,tt);
    }

    public static void main(String[] args) {		
	// first, we ramp up
	boolean f = true;
	System.err.println("-- RAMPING UP --");
	for(int i=0;i!=1;++i) {	    
	    Result r = doTest();
	}

	System.err.println("-- RUNNING TEST --");
	// Now, actually measure it
	long aAvg = 0;
	long ttAvg = 0;
	int nIters = 10;
	

	for(int i=0;i!=nIters;++i) {	    
	    Result r = doTest();
	    aAvg += r.addTime;
	    ttAvg += r.traverseTime;
	}

	double aa = ((double) aAvg) / nIters;
	double tta = ((double) ttAvg) / nIters;
	double ta = ((double) aAvg + ttAvg) / nIters;

	System.out.println("enrolTime\ttravTime\ttotalTime");
	System.out.println(aa + "\t" + tta + "\t" + ta);
	System.err.println("TOTAL IS: " + total);
    }
}
