import java.util.*;

public class City {
    private String _name;
    final private HashSet<Road> _to = new HashSet<Road>();
    final private HashSet<Road> _from = new HashSet<Road>();

    public City(String c) {
	_name = c;
    }

    public String name() { 
	return _name;
    }

    public String toString() {
	return _name;
    }

    public boolean equals(Object o) {
	City c = (City) o;
	return c._name.equals(_name);
    }

    public int hashCode() { return _name.hashCode(); }

    public int compareTo(City o) {	 
	return _name.compareTo(o._name);
    }

    public HashSet<Road> to() { return _to; }
    public HashSet<Road> from() { return _from; }

    public void addFrom(Road r) { _from.add(r); }
    public void addTo(Road r) { _to.add(r); }

    public int getShortestRoute(City to) {	
	HashMap<City,Distance> E = new HashMap<City,Distance>();	
	PriorityQueue<Distance> Q = new PriorityQueue();
	
	// ------- Initialise Q ------
	Distance d = new Distance(0,this);
	E.put(this,d);
	Q.add(d);	
 	
	// ------- Perform Relaxation ------
	while(!Q.isEmpty()) {
	    Distance u = Q.poll();
	    if(u.city.equals(to)) { return u.distance; }
	    
	    for(Road r : u.city.from()) {
		int n = u.distance + r.distance();
		Distance c = E.get(r.to());
		if(c == null) {
		    // null indicates infinite distance
		    c = new Distance(n,r.to());
		    E.put(r.to(),c);
		    Q.add(c);
		} else if(n < c.distance) {
		    Q.remove(c);
		    c.distance = n;
		    Q.add(c);
		}
	    }
	} 	
	return -1;
    }

    static final private class Distance implements Comparable<Distance> {
	public int distance;
	public City city;  
	
	public Distance(int t, City c) {
	    distance=t; city=c;
	}
	public int compareTo(Distance o) {
	    if(distance < o.distance) { return -1; }
	    else if(distance > o.distance) { return 1; }
	    else return city.compareTo(o.city);
	}
    }
}
