import java.util.*;
import ral.util.*;
import ral.base.*;

// swap between these two lines to use a different implementation
// public class RoadNetwork extends HashRel<City,City,Road> {
public aspect RoadNetwork extends StaticRel<City,City,Road> {
	
  public int getShortestRoute(City from, City to) {
      
      HashMap<City,Distance> E = new HashMap<City,Distance>();	
      PriorityQueue<Distance> Q = new PriorityQueue();

      // ------- Initialise Q ------
      Distance d = new Distance(0,from);
      E.put(from,d);
      Q.add(d);	

      // ------- Perform Relaxation ------
      while(!Q.isEmpty()) {
	  Distance u = Q.poll();
	  if(u.city.equals(to)) { return u.distance; }

	  for(Road r : fromAssoc(u.city)) {
	      int n = u.distance + r.distance();
	      Distance c = E.get(r.to());
	      if(c == null) {
		  // null indicates infinite distance
		  c = new Distance(n,r.to());
		  E.put(r.to(),c);
		  Q.add(c);
	      } else if(n < c.distance) {
		  Q.remove(c);
		  c.distance = n;
		  Q.add(c);
	      }
	  }
      } 

      return -1;
  }

 static final private class Distance implements Comparable<Distance> {
     public int distance;
     public City city;  
	
     public Distance(int t, City c) {
	 distance=t; city=c;
     }
    
     public int compareTo(Distance o) {
	 if(distance < o.distance) { return -1; }
	 else if(distance > o.distance) { return 1; }
	 else return city.compareTo(o.city);
     }
 }}
