import java.util.*;

// Random graph generator
public class Generate {
    public static void main(String args[]) { 
	String names[] = {"London",
			  "Birmingham",
			  "Cambridge",
			  "Oxford",
			  "Warwick",
			  "Brighton",
			  "Glasgow",
			  "Edinburgh",
			  "Leicester",
			  "Durham",
			  "Chester",
			  "Norwich",
			  "Gloucester",
			  "Portsmouth",
			  "Southhampton",
			  "Christchurch",
			  "Northhampton",
			  "Leeds",
			  "Sale",
			  "Peterborough",
			  "Bath",
			  "Aberdeen",
			  "Torquay",
			  "Cardiff",
			  "Carlisle",
			  "Newcastle",
			  "Liverpool",
			  "Bristol",
			  "Manchester",
	                  "Bolton",
			  "Dover",
			  "Lincoln",
			  "Aldershot",
			  "Plymouth",
			  "Felixstowe",
			  "Wells",
			  "Hunstanton",
			  "Holcolm",
			  "Great-Yarmouth",
			  "Stratford",
			  "York",
			  "Bradford",
			  "Ely",
			  "Canterbury",
			  "Chichester",
			  "Coventry",
			  "Derby",
			  "Lancaster",
			  "Preston",
			  "St-Albans",
			  "Sheffield",
			  "Winchester",
			  "Wolverhampton",
			  "Worcester",
			  "Stoke-on-Trent",
			  "Sunderland",
			  "Truro",
			  "Ealing",
			  "Acton",
			  "Hammersmith",
			  "Croydon",
			  "South-Kensington",
			  "Gloucester-Road",
			  "Chiswick",
			  "Green-Park",
			  "Picadilli",
			  "Euston",
			  "Kings-Cross",
			  "Liverpool-Street",
			  "Fulham-Broadway",
			  "Putney",
			  "West-Acton",
			  "West-Ealing",
			  "Auckland",
			  "Wellington",
			  "Nelson",
			  "Levine",
			  "Palmerston-North",
			  "Lower-Hutt",
			  "Uppper-Hutt",
			  "Napier",
			  "Taupo",
			  "Rotorua",
			  "Invercargill",
			  "Dunedin",
			  "Blenheim",
			  "Porirua",
			  "Kapiti",
			  "Masterton",
			  "Martinborough",
			  "Marlborough",
			  "Picton",
			  "Washington-DC",
			  "Manhatten",
			  "Chicago",
			  "San-Francisco",
			  "Boston",
			  "Newark",
			  "Los-Angelis",
			  "Los-Vegas",
			  "Houston",
			  "New-Orleans",
			  "Berkley"			  
	};

	HashSet<Edge> E = new HashSet();

	int nroads = 250;

	if(args.length > 0) {
	    nroads = Integer.parseInt(args[0]);
	}

	for(int i=0;i!=nroads;++i) {
	    // each road max 100 miles
	    int dist = (int) (Math.random() * 100);
	    int from = (int) (Math.random() * names.length);
	    int to = (int) (Math.random() * names.length);
	    if(E.add(new Edge(names[from],names[to]))) {
		System.out.println(names[from] + "\t" + names[to] + "\t" + dist);
	    }
	}
    }
    
    private static class Edge {
	private String from;
	private String to;
	
	public Edge(String f, String t) {
	    from = f;
	    to = t;
	}

	public boolean equals(Edge e) {
	    return from == e.from && to == e.to;
	}
    }
}
