import ral.base.*;
import ral.util.*;
import java.util.*;
import java.io.*;

public class Benchmark {
    static String readFile(String file) {
	try {
	    BufferedReader input = new BufferedReader(
                                   new InputStreamReader(
                                   new FileInputStream(file)));
	    
	    StringBuffer text = new StringBuffer();
	    while (input.ready()) {
		text.append(input.readLine());
		text.append("\n");
	    }
	    
	    return text.toString();
	} catch(FileNotFoundException e) {
	    throw new RuntimeException("File not found.");
	} catch(IOException e) {
	    throw new RuntimeException("I/O Error.");
	}
    }

    static boolean isWhiteSpace(char c) {
	// could use Character.isWhiteSpace method here ...
	return c == ' ' || c == '\t' || c == '\n';
    }

    static int skipWhiteSpace(String input, int index) {
	// remove all whitespace, including comments,
	// at current position
	while(index < input.length() && isWhiteSpace(input.charAt(index))) {
	    ++index;
	}
	return index;
    }
    
    static String parseString(String input, int index) {
	String r;
	StringBuffer buf = new StringBuffer();
	while(index < input.length() && !isWhiteSpace(input.charAt(index))) {	    
	    buf.append(input.charAt(index++));
	}
	return buf.toString();
    }

    static public List<Road> parseFile(String input) {
	List<Road> r = new ArrayList<Road>();
	HashMap<String,City> H = new HashMap<String,City>();
	int index = 0;
	while(index < input.length()) {	    
	    index = skipWhiteSpace(input,index);
	    String from = parseString(input,index);
	    index = skipWhiteSpace(input,index + from.length());
	    String to = parseString(input,index);
	    index = skipWhiteSpace(input,index + to.length());
	    String tmp = parseString(input,index);
	    index += tmp.length();
	    if(!tmp.equals("")) {
		int distance = Integer.parseInt(tmp);
		City fromCity = H.get(from);
		if(fromCity == null) { 
		    fromCity = new City(from);
		    H.put(from,fromCity);
		}
		City toCity = H.get(to);
		if(toCity == null) { 
		    toCity = new City(to);
		    H.put(to,toCity);
		}
		
		Road rd = new Road(fromCity,toCity,distance);
		r.add(rd);
	    }
	}
	return r;
    }

    public static void main(String[] args) {		
	// --- READ INPUT FILE ---
	System.err.print("Reading and parsing input file ...");
        List<Road> roads = parseFile(readFile(args[0]));
	HashSet<City> cities = new HashSet<City>();
	RoadNetwork network = RoadNetwork.aspectOf();
	// RoadNetwork network = new RoadNetwork();
	System.err.println("done");
	// build relationship
	System.err.print("Building relationship ...");       
	for(Road r : roads) { 
	    cities.add(r.from());
	    cities.add(r.to());
	    network.add(r); 
	}
	System.err.println("done");
	long total=0;
	int niters = 10;
	for(int i=0;i!=niters;++i) {
	    System.err.print("#" + i + " Computing all shortest paths ... ");
	    long start = System.currentTimeMillis();
	    
	    // Now, compute shortest route from every city?
	    int count = 0;
	    for(City from : cities) {
		for(City to : cities) {
 		    int distance = network.getShortestRoute(from,to);
		    if(distance < 0) {
			//System.out.println("There is no route from " + from + " to " + to + ".");	   
		    } else {
			count = count + 1;
			//System.out.println("Shortest Route from " + from + " to " + to +" is " + distance + " miles");
		    }
		}
	    }
	
	    long end = System.currentTimeMillis();
	    System.err.println("done (" + (end-start) + "ms, total = " + count + ")");
	    total += end - start;
	} 
	double avg = ((double) total) / niters;
	System.err.print("Average time: " + avg + "ms");
    }
}
