import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

/**
 * 
 * @author Vlad-Alexandru Slavici
 *
 */

class TransitionManager{
	CSP csp;
	boolean decideInitial;
	
	public TransitionManager(CSP csp){
		this.csp=csp;
		decideInitial=true;
	}
	
	/**
	 * sees if we can apply UP-rule
	 * 
	 * 
	 * @return true if we can apply unit propagation
	 */
	
	public boolean unitPropagation(){
		for (int i=0;i<csp.unassigned.size();i++){
			Integer var=(Integer)csp.unassigned.get(i);
			
			//try forcing var=1
			
			HashMap temp_assignment=new HashMap(csp.assignment);
			
			temp_assignment.put(var, new Integer(0));
			
			if (Check.checkUnsat(temp_assignment, csp)>=csp.previous_unsat){
				
				csp.assignment.put(var, new Integer(1));
				csp.unassigned.remove(csp.unassigned.indexOf(var));
				if (csp.verbose){
					System.out.println("Unit propagation : set "+var+" to 1"+Check.checkUnsat(temp_assignment, csp));
				}
				
				return true;
			}
			
			//try forcing var=0
			
			temp_assignment=new HashMap(csp.assignment);
			temp_assignment.put(var, new Integer(1));
			
			if (Check.checkUnsat(temp_assignment, csp)>=csp.previous_unsat/*Check.checkUnsat(test.previous_best, test)*/){
				csp.assignment.put(var, new Integer(0));
				csp.unassigned.remove(csp.unassigned.indexOf(var));
				if (csp.verbose){
					System.out.println("Unit propagation : set "+var+" to 0"+Check.checkUnsat(temp_assignment, csp));
				}
				
				return true;
			}
		}
		return false;
	}
	
	public void decide(){
		//deciding a variable the first time after a restart
		if (decideInitial){
			Check.computePairs(true,csp);
			
			VarAssign var_to_assign=Decide.choose(csp,true);
			VarAssign va=new VarAssign(var_to_assign.var,new Integer(1-var_to_assign.as.intValue()));
			
			//va is the negation of var_to_assign
			
			//if a variable can be set either to 0 or to 1 without violating any superresolvents,
			//then we set it to 0( decide)
			if (Check.canDecide(var_to_assign,csp)){
				if (Check.canDecide(va, csp)){
					csp.unassigned.remove(csp.unassigned.indexOf(var_to_assign.getVar()));
					csp.assignment.put(var_to_assign.getVar(), var_to_assign.getAssign());	
				
					if (csp.verbose){
						System.out.println("Decide: set "+var_to_assign.getVar()+" to "+var_to_assign.getAssign());
					}
			
					csp.decide.add(va);
				}
				else{
					//this variable is enforced by the superresolvents
					csp.unassigned.remove(csp.unassigned.indexOf(var_to_assign.getVar())); 
					csp.assignment.put(var_to_assign.getVar(), var_to_assign.getAssign());
					
					if (csp.verbose){
						System.out.println("Superresolution: set "+var_to_assign.getVar()+" to "+var_to_assign.getAssign());
					}
				}
			}
			else{
//				//this variable is enforced by the superresolvents
				
				//this is just a test for system correctness: it should always return true
				if (!Check.canDecide(va, csp)){
					System.exit(-1);
				}
				
				csp.unassigned.remove(csp.unassigned.indexOf(var_to_assign.getVar()));
				VarAssign v_a= new VarAssign(var_to_assign.getVar(),new Integer(1-var_to_assign.getAssign().intValue())); 
				csp.assignment.put(v_a.getVar(), v_a.getAssign());			
				
				if (csp.verbose){
					System.out.println("Superresolution: set "+v_a.getVar()+" to "+v_a.getAssign());
				}
			}
			decideInitial=false;
		}
		else{//deciding a variable, except for the first time after a restart
			Check.computePairs(false,csp);
			
			VarAssign var_to_assign=Decide.choose(csp,false);
			VarAssign va=new VarAssign(var_to_assign.var,new Integer(1-var_to_assign.as.intValue()));
			
			if (Check.canDecide(var_to_assign,csp)){
				if (Check.canDecide(va, csp)){
					csp.unassigned.remove(csp.unassigned.indexOf(var_to_assign.getVar()));
					csp.assignment.put(var_to_assign.getVar(), new Integer(var_to_assign.getAssign()));	
			
					if (csp.verbose){
						System.out.println("Decide: set "+var_to_assign.getVar()+" to "+var_to_assign.getAssign());
					}
				
					csp.decide.add(va);
				}
				else{
					csp.unassigned.remove(csp.unassigned.indexOf(var_to_assign.getVar())); 
					csp.assignment.put(var_to_assign.getVar(), var_to_assign.getAssign());
					
					if (csp.verbose){
						System.out.println("Superresolution: set "+var_to_assign.getVar()+" to "+var_to_assign.getAssign());
					}
				}
			}
			else {
				
				if (!Check.canDecide(va, csp)){
					System.exit(-1);
				}
				
				csp.unassigned.remove(csp.unassigned.indexOf(var_to_assign.getVar()));
				VarAssign v_a= new VarAssign(var_to_assign.getVar(),new Integer(1-var_to_assign.getAssign().intValue())); 
				csp.assignment.put(v_a.getVar(), v_a.getAssign());
				
				if (csp.verbose){
					System.out.println("Superresolution: set "+v_a.getVar()+" to "+v_a.getAssign());
				}
			}
		}
	}
	
	public void start(){
		
		int c=0;
		
		while (true){
		
			decideInitial=true;
			
			if (csp.unassigned.size()==0){
				if (csp.decide.size()==0 && c>0){
					//if in the last iteration we haven't decided anything, it means we've reached 
					//MAX-SAT
					if (Check.checkMAXSAT(csp.assignment,csp)>Check.checkMAXSAT(csp.previous_best, csp)){
						csp.previous_best=new HashMap(csp.assignment);
						csp.previous_unsat=Check.checkUnsat(csp.assignment, csp);
					}
					Vector pv_b=new Vector(csp.previous_best.keySet());
					Collections.sort(pv_b);
					if (csp.verbose){
						System.out.println("The number of n-Mappings up to this step:"+Decide.c);
					}
					System.out.print("     Best found Assignment:      ");
					for (int i=0;i<pv_b.size();i++){
						if (((Integer)pv_b.get(i)).intValue()>0)
						System.out.print((Integer)pv_b.get(i)+"="+csp.previous_best.get((Integer)pv_b.get(i))+" ,  ");
					}
					System.out.print(" with unsat: "+Check.checkUnsat(csp.previous_best, csp)+"/"+csp.total_nr+"  =  "+1.0*Check.checkUnsat(csp.previous_best, csp)/csp.total_nr);
					break;
				}
				if (Check.checkSAT(csp)){
					csp.previous_best=new HashMap(csp.assignment);
					Vector pv_b=new Vector(csp.previous_best.keySet());
					Collections.sort(pv_b);
					System.out.println("c="+Decide.c);
					System.out.print("     Best found Assignment:      ");
					for (int i=0;i<pv_b.size();i++){
						if (((Integer)pv_b.get(i)).intValue()>0)
							System.out.print((Integer)pv_b.get(i)+"="+csp.previous_best.get((Integer)pv_b.get(i))+" ,  ");
					}
					System.out.print(" with unsat: "+Check.checkUnsat(csp.previous_best, csp)+"/"+csp.total_nr+"  =  "+1.0*Check.checkUnsat(csp.previous_best, csp)/csp.total_nr);
					break;
				}
				else{
					if (Check.checkMAXSAT(csp.assignment,csp)>Check.checkMAXSAT(csp.previous_best, csp)){
						csp.previous_best=new HashMap(csp.assignment);
						csp.previous_unsat=Check.checkUnsat(csp.assignment, csp);
						System.out.println("c="+Decide.c);
						System.out.println("Found a better assignment than the previous one ! ");
						Vector pv_b=new Vector(csp.previous_best.keySet());
						Collections.sort(pv_b);
						System.out.print("   Current  best found Assignment:      ");
						for (int i=0;i<pv_b.size();i++){
							if (((Integer)pv_b.get(i)).intValue()>0)
						System.out.print((Integer)pv_b.get(i)+"="+csp.previous_best.get((Integer)pv_b.get(i))+" ,  ");
						}
System.out.print(" with unsat: "+Check.checkUnsat(csp.previous_best, csp)+"/"+csp.total_nr+"  =  "+1.0*Check.checkUnsat(csp.previous_best, csp)/csp.total_nr);
					}
					else if (c>0) {
						System.out.println("c="+Decide.c);
						System.out.println("New found Assignment is not better than the old one: \n "+Check.checkMAXSAT(csp.assignment,csp)+" "+Check.checkMAXSAT(csp.previous_best, csp));
						csp.superresolution.add(new Vector(csp.decide));
					}
									
					csp.unassigned=new Vector(csp.variables.keySet());
					csp.current_relations=new Vector(csp.relations);
					csp.assignment.clear();
					csp.decide.clear();
					
	
					csp.pairs.clear();
				
					HashMap pairsaux=new HashMap();
					
					//initialize pairs
					for (int i=0;i<csp.num_rel;i++){
						if (pairsaux.containsKey(new Integer(((Rel3)csp.relations.get(i)).number))){
							int k=((Integer)pairsaux.get(new Integer(((Rel3)csp.relations.get(i)).number))).intValue();
							pairsaux.put(new Integer(((Rel3)csp.relations.get(i)).number),new Integer(k+((Rel3)csp.relations.get(i)).weight));
						}
						else{
							pairsaux.put(new Integer(((Rel3)csp.relations.get(i)).number),new Integer(((Rel3)csp.relations.get(i)).weight));
						}	
					}
					
					Iterator it=pairsaux.keySet().iterator();
					
					while (it.hasNext()){
						Integer relnum=(Integer)it.next();
						Integer fraction=(Integer)pairsaux.get(relnum);
					
						csp.pairs.add(new Pair(relnum.intValue(), fraction.intValue()*1.0/csp.total_nr));
					}	
					
					
					csp.addedPairs.clear();
					csp.subtractedPairs.clear();
					
					
					csp.current_polynomial=new Polynomial(0,0,0,0);
					
					//the main loop:
					while (csp.unassigned.size()>0){
						if (!unitPropagation()){
								decide();
						}
					}
				
				}
			}
		
			c++;
		}
		
		
		//this piece of code was used for the derandomized algorithm
		/*
		if (Check.checkMAXSAT(csp.assignment,csp)>Check.checkMAXSAT(csp.previous_best, csp)){
			csp.previous_best=new HashMap(csp.assignment);
			csp.previous_unsat=Check.checkUnsat(csp.assignment, csp);
		}
		Vector pv_b=new Vector(csp.previous_best.keySet());
		Collections.sort(pv_b);
		System.out.print("     Best found assignment:      ");
		for (int i=0;i<pv_b.size();i++){
			if (((Integer)pv_b.get(i)).intValue()>0)
			System.out.print((Integer)pv_b.get(i)+"="+csp.previous_best.get((Integer)pv_b.get(i))+" ,  ");
		}
		System.out.print(" with unsat: "+Check.checkUnsat(csp.previous_best, csp)+"/"+csp.total_nr+"  =  "+1.0*Check.checkUnsat(csp.previous_best, csp)/csp.total_nr);
		*/
	}
}