/**
 * The PairI interface is used to encapsulate relation number/fraction
 * pairs.
 * <p>
 * This is used in the input interfaces.
 */
public interface PairI {
  /**
   * Returns the relation number for this pair.  
   *
   * Valid relation numbers are between 0 and 255 (inclusive).
   * 
   * @return the relation number for this pair.
   */   
  public int getRelationNumber();

  /**
   * Returns the fraction of constraints that are of this
   * relation number.
   *
   * Valid fractions are between 0 and 1.
   * 
   * @return fraction
   */
  public double getFraction();
}
