import java.io.*;
import java.util.*;

public class CSP implements InputInitialI,InputUpdateI{
	
	Vector pairs;//mutable
	Polynomial current_polynomial;
	Set addedPairs;//mutable
	Set subtractedPairs;//mutable
	int num_var,num_rel;
	HashMap variables;
	HashMap pos_variables;
	Vector relations;
	Vector current_relations;//mutable
	double p,q;
	HashMap assignment;//mutable
	Vector unassigned;//mutable
	boolean verbose;
	
	HashMap previous_best;//mutable
	
	Vector superresolution;
	
	Vector decide;
	
	int total_nr=0;
	
	Vector unique_constraints;
	
	int previous_unsat;
	
	public CSP(){
		pairs=new Vector();
		current_polynomial=new Polynomial(0,0,0,0);
		addedPairs=new HashSet();
		subtractedPairs=new HashSet();
		variables=new HashMap();
		pos_variables=new HashMap();
		assignment=new HashMap();
		unassigned=new Vector();
		relations=new Vector();
		current_relations=new Vector();
		
		superresolution=new Vector();
		
		decide=new Vector();
		
		unique_constraints=new Vector();
		
		previous_best=new HashMap();
		p=.1;
		q=.1;
		
		verbose=false;
	}
	
	public CSP(double p,double q){
		pairs=new Vector();
		current_polynomial=new Polynomial(0,0,0,0);
		addedPairs=new HashSet();
		subtractedPairs=new HashSet();
		variables=new HashMap();
		pos_variables=new HashMap();
		assignment=new HashMap();
		unassigned=new Vector();
		relations=new Vector();
		current_relations=new Vector();
		
		superresolution=new Vector();
		
		decide=new Vector();
		
		unique_constraints=new Vector();
		
		previous_best=new HashMap();
		this.p=p;
		this.q=q;
		
		verbose=false;
	}
	
	public Set getPairs(){
		
		return new HashSet(pairs);
	}
	
	public Set getAddedPairs(){
		return new HashSet(addedPairs);
	}
	
	public Set getSubtractedPairs(){
		return new HashSet(subtractedPairs);
	}
	
	public PolynomialI getPolynomialBefore(){
		return current_polynomial;
	}
	
	
	
	public static void main(String args[])throws IOException{
		CSP csp=new CSP();
		InputReader.readInput(args[0],csp);
		
		
		if (args.length>1){
			//we check if verbose mode is set
			if (args[1].compareTo("-v")==0){
				csp.verbose=true;
			}
		}
		
		//validate input
		if (csp.num_rel!=csp.relations.size() || csp.pos_variables.size()!=csp.num_var)
		{
			System.out.println("Input format not respected;;   "+csp.relations);
			System.exit(-1);
		}			
		HashMap pairsaux=new HashMap();
		
		//initialize pairs
		for (int i=0;i<csp.num_rel;i++){
			if (pairsaux.containsKey(new Integer(((Rel3)csp.relations.get(i)).number))){
				int k=((Integer)pairsaux.get(new Integer(((Rel3)csp.relations.get(i)).number))).intValue();
				pairsaux.put(new Integer(((Rel3)csp.relations.get(i)).number),new Integer(k+((Rel3)csp.relations.get(i)).weight));
			}
			else{
				pairsaux.put(new Integer(((Rel3)csp.relations.get(i)).number),new Integer(((Rel3)csp.relations.get(i)).weight));
			}
				
		}
		
		Iterator it=pairsaux.keySet().iterator();
		
		while (it.hasNext()){
			Integer relnum=(Integer)it.next();
			Integer fraction=(Integer)pairsaux.get(relnum);
		
			csp.pairs.add(new Pair(relnum.intValue(), fraction.intValue()*1.0/csp.total_nr));
		}		
		
		csp.current_relations=new Vector(csp.relations);
		
		it=csp.variables.keySet().iterator();
		
		while (it.hasNext()){
			csp.assignment.put(it.next(), new Integer(0));
		}
	
		csp.previous_best=new HashMap(csp.assignment);
		csp.previous_unsat=Check.checkUnsat(csp.assignment, csp);
		
		System.out.println("Assignment: "+csp.assignment);
		
		//start the transition manager
		TransitionManager tmanager=new TransitionManager(csp);
		tmanager.start();
		
	}
}