/**
 * Code by Daniel Rinehart <danielr@neophi.com>
 * Created for CSG260 Fall 2006 with Karl Lieberherr
 */


/**
 * Utility class used to generate and cache polynomials generated for relation
 * numbers.
 */
public class AppSAT {
	private static final Polynomial POLYNOMIALS[] = new Polynomial[256];

	/**
	 * Private constructor to force utility class usage.
	 */
	private AppSAT() {
	}

	/**
	 * Create the appSAT sum for the given relation.
	 * 
	 * @param relationNumber
	 *            Relation to calculate
	 * @return Polynomial for the relation
	 */
	public static Polynomial appSAT(int relationNumber) {
		// cache results as needed
		if (POLYNOMIALS[relationNumber] != null) {
			return POLYNOMIALS[relationNumber];
		}
		// the rank is fixed at 3 in order to
		// get the correct results from Relation
		Polynomial polynomial = null;
		for (int s = 0; s <= 3; s++) {
			Polynomial temp = getPolynomial(s);
			//System.out.println(Relation.q(relationNumber, s));
			temp = temp.multiply(Relation1.q(relationNumber, s));
			if (polynomial == null) {
				polynomial = temp;
			} else {
				polynomial = polynomial.add(temp);
			}
		}
		POLYNOMIALS[relationNumber] = polynomial;
		return polynomial;
	}

	// r(R) s r(R)-s x^s*(1-x)^(r(R)-s) x^3 x^2 x^1 x^0
	// 3 0 3 x^0*(1-x)^3 -1 3 -3 1
	// 3 1 2 x^1*(1-x)^2 1 -2 1 0
	// 3 2 1 x^2*(1-x)^1 -1 1 0 0
	// 3 3 0 x^3*(1-x)^0 1 0 0 0
	private static final Polynomial C03 = new Polynomial(-1, 3, -3, 1);

	private static final Polynomial C12 = new Polynomial(1, -2, 1, 0);

	private static final Polynomial C21 = new Polynomial(-1, 1, 0, 0);

	private static final Polynomial C30 = new Polynomial(1, 0, 0, 0);

	/**
	 * Return the polynomial for s given a fixed rank of 3.
	 * 
	 * @param s
	 *            S
	 * @return coefficients
	 */
	private static Polynomial getPolynomial(int s) {
		switch (s) {
		case 0:
			return C03;
		case 1:
			return C12;
		case 2:
			return C21;
		case 3:
			return C30;
		}
		throw new IllegalArgumentException("s = " + s + " is not valid.");
	}
}
