package edu.neu.ccs.demeter.daj.eclipse.internal.core;

//JDK
import java.util.List;
import java.util.Vector;
import java.util.ArrayList;
import java.io.File;

//Eclipse core
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPluginDescriptor;

//Eclipse JDT
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.ILaunchManager;

//AspectJ Tools
import org.aspectj.tools.ajc.Main;

//Plug-in
import edu.neu.ccs.demeter.daj.eclipse.DAJPlugin;
public class DAJUtils {

  /**
  * Returns files within project with extensions given 
  * If isJavaSourceOnly is set to true - we search only
  * within java source code files set.
  */
  public static String[] getProjectFiles(IProject project,String[] extentions,boolean isJavaSourceOnly) {

    List files = new ArrayList();
    try {
      //If we wanna search only within Java source files for the project...
      if (isJavaSourceOnly) {
        IJavaProject jProject = JavaCore.create(project);		
     	IClasspathEntry[] classpathEntries = jProject.getResolvedClasspath(false);
    	for (int i = 0; i < classpathEntries.length; i++) {
    	  if (classpathEntries[i].getEntryKind() == IClasspathEntry.CPE_SOURCE ) {
    	    IClasspathEntry sourceEntry = classpathEntries[i];
    	    IPath sourcePath = sourceEntry.getPath();
            // remove the first segment because the findMember call following
    	    // always adds it back in under the covers (doh!) and we end up
            // with two first segments otherwise!
    	    sourcePath = sourcePath.removeFirstSegments(1); 
    	    IResource[] containers = new IResource[] {project.findMember(sourcePath)};
            getAllFiles(containers,files,extentions);
    	}
    	}
      } else {
        IResource[] containers = project.members();
        getAllFiles(containers,files,extentions);
      }
    } catch (Exception e) {
      e.printStackTrace();
    }
    String[] result=new String[files.size()];
    for (int i=0;i<files.size();i++)	
     result[i] = (String)files.get(i);
    return result;
  }

   /**
    * Returns files with specified extensions from given containers
    */
   public static void getAllFiles(IResource[] containers,List files, String[] extensions) {
     if (extensions==null || extensions.length==0 || 
         containers==null || containers.length==0 ||
         files==null) return;

     try {
       for (int i = 0; i < containers.length; i++) {
     	 IResource ir = containers[i];
     	 String name=ir.getName();
     	 boolean isApt=false;
         for (int j=0;j<extensions.length;j++) {
           if (name.endsWith("."+extensions[j])) {
             isApt=true; break;
           } 
         }

   	 if (isApt) {
   	   files.add(ir.getLocation().toOSString());
   	 }

   	 if (ir instanceof IContainer) {
   	   getAllFiles(((IContainer) ir).members(), files, extensions);
   	 }
       }
     } catch (Exception e) {
   	e.printStackTrace();
     }
   }
  
 /**
  * Returns classpath for Java project given 
  */
  public static String[] getClassPath(IProject project) {
    try{
      return JavaRuntime.computeDefaultRuntimeClassPath(JavaCore.create(project));
    } catch (Exception e) {
      return null;
    }
  }

 /**
  * run mainClass in JVM for the given project
  */
  public static ILaunch runJVM(IJavaProject jp,String mainClass,String[] addClassPath,String[] args) {
    try{  
      String[] classpath = null;
      if (jp!=null) {
        classpath = JavaRuntime.computeDefaultRuntimeClassPath(jp);
      }
      if (classpath==null) classpath=new String[0];
      if (addClassPath!=null && addClassPath.length>0) {
        String[] newClassPath=new String[classpath.length+addClassPath.length];
        System.arraycopy(classpath,0,newClassPath,0,classpath.length);
        System.arraycopy(addClassPath,0,newClassPath,classpath.length,addClassPath.length);
        classpath=newClassPath;
      }
      printArray("Classpath:",classpath);
      printArray("options:",args);

      IVMRunner runner = JavaRuntime.getDefaultVMInstall().getVMRunner(ILaunchManager.RUN_MODE);
      VMRunnerConfiguration conf = new VMRunnerConfiguration(mainClass,classpath);
      if (args!=null) conf.setProgramArguments(args);

      if (jp!=null) {
        //conf.setWorkingDirectory(jp.getProject().getPluginWorkingLocation(Platform.getPluginRegistry().getPluginDescriptor(DAJPlugin.ID)).makeAbsolute().toOSString());
        conf.setWorkingDirectory(jp.getProject().getLocation().makeAbsolute().toOSString());
      }

      ILaunch launch=new Launch(null,ILaunchManager.RUN_MODE,null);
      runner.run(conf,launch,null);
      return launch;
    } catch (CoreException e) {
      e.printStackTrace();
      return null;
    }
  }

 /**
  * runs mainClass in JVM with given classpath and arguments
  */
  public static ILaunch runJVM(String mainClass,String[] addClassPath,String[] args) {
    return runJVM(null,mainClass,addClassPath,args);
  }

 /**
  * runs AspectJ compiler with options given. 
  */
  public static void compile(String[] options,String[] files) throws java.io.IOException {
    if (files==null || files.length==0) return;
    if (options==null) options=new String[0];
    String[] params = new String[files.length+options.length];
    System.arraycopy(options,0,params,0,options.length);
    System.arraycopy(files,0,params,options.length,files.length);
    System.out.println("Starting compiling");

    org.aspectj.tools.ajc.Main.main(params);
  }


 /**
  * runs AspectJ compiler. 
  */
  public static ILaunch compile(IJavaProject jp,String[] classPath,String[] options,String[] files) throws java.io.IOException {
    if (files==null || files.length==0) return null;
    if (options==null) options=new String[0];
    String[] params = new String[files.length+options.length];
    System.arraycopy(options,0,params,0,options.length);
    System.arraycopy(files,0,params,options.length,files.length);
    System.out.println("Starting compiling");
    return runJVM(jp,"org.aspectj.tools.ajc.Main",classPath,params);
  }


  public static void printArray(String title,String[] arr) {
    System.out.println(title);
    if (arr==null) {System.out.println("arr=null");return;}
    for (int i=0;i<arr.length;i++)
     System.out.println(arr[i]);
  }

  public static void activatePlugin(String id) {
    try{
      IPluginDescriptor ajdescr= Platform.getPluginRegistry().getPluginDescriptor(id);
      if (!ajdescr.isPluginActivated()) ajdescr.getPlugin();
    } catch (Exception e) {
      e.printStackTrace();
    }
  }
}