package edu.neu.ccs.demeter.daj.eclipse.internal.builder;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import java.util.Stack;

class StreamListener implements IStreamListener {

  private StringBuffer content = new StringBuffer();
  private Stack stack=new Stack();
  private String lastAppended=null;

  StreamListener () {}

  public void streamAppended(String text, IStreamMonitor monitor) {
     content.append(text);
     if (text!=null) {
       if (text.endsWith("\n") || text.endsWith("\r"))  text=text.substring(0,text.length()-1);
       if (text.endsWith("\n") || text.endsWith("\r"))  text=text.substring(0,text.length()-1);
       if (text.startsWith("\n") || text.startsWith("\r"))  text=text.substring(1);
       if (text.startsWith("\n") || text.startsWith("\r"))  text=text.substring(1);
       if (text.length()>0) lastAppended=text;
       if (ProblemParser.isValidProblem(text)) {
         stack.add(text);
       }
     }
  }

  public String getStreamContent(){
    return content.toString();
  }
  public String getLastAppended() {
    return lastAppended;
  }
  public Stack getMessagesStack() {
    return (Stack)stack.clone();
  }
}