package edu.neu.ccs.demeter.daj.eclipse.internal.builder;
import java.util.StringTokenizer;

class ProblemParser {

  static String DAJ_PROBLEM_ID="DAJPROBLEM";
  static String SEPARATOR="|";
  /*
    String representation of the error is:
    DAJ_PROBLEM_ID|MESSAGE|SEVERITY|LOCATION|LINE|CHAR_START|CHAR_END
    ANY OF THEM (EXCEPT DAJ_PROBLEM_ID) COULD BE EMPTY
  */

  /** Called by DAJCompiler when it receives exception from 
   *  underlied layer. Returns string representation of this exception
   *  or null if exception is unknown...
   *  Location is absolute path to resource, that produces an error
   *  on a local file system. (For some kinds of exceptions can be null?)
   */
  static String getProblemAsString(Exception exc,String location) {

    //if (exc==null) return null;
    if (location==null) location=" "; 
    String message="Unknown problem";
    String line=" ";
    String char_start=" ";
    String char_end=" ";
    String severity = " ";

    return DAJ_PROBLEM_ID+SEPARATOR+
    message+SEPARATOR+
    severity+SEPARATOR+
    location+SEPARATOR+
    line+SEPARATOR+
    char_start+SEPARATOR+
    char_end+SEPARATOR;

  }

  /** Called by Builder after compilation finished.
   *  Converts string (usually produced by getProblemAsString)
   *  into Problem.
   */
  static Problem getProblem(String problem) {
    if (!isValidProblem(problem)) return null;
    try{
      StringTokenizer st = new StringTokenizer(problem,SEPARATOR);
      st.nextToken(); //DAJ_PROBLEM_ID

      Problem prob = new Problem();
      prob.setMessage(st.nextToken());
      prob.setSeverity(st.nextToken());
      prob.setLocation(st.nextToken());
      prob.setLine(st.nextToken());
      prob.setCharStart(st.nextToken());
      prob.setCharEnd(st.nextToken());

      return prob;

    } catch (Exception e) {
      System.err.println(e.toString());
      return null;
    }
  }

  /**Returns if parameter is a valid DAJProblem string representation.
   *
   */
  static boolean isValidProblem(String problem) {
    return (problem!=null && problem.startsWith(DAJ_PROBLEM_ID));
  }

}