package edu.neu.ccs.demeter.daj.eclipse.internal.builder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Path;

class Problem {
  static int UNSPECIFIED_VALUE = -1;
  private String location;
  private String message;
  private int line;
  private int severity;
  private int char_start;
  private int char_end;

  Problem () {

    location=null;
    message=null;
    line = UNSPECIFIED_VALUE;
    severity = UNSPECIFIED_VALUE;
    char_start= UNSPECIFIED_VALUE;
    char_end= UNSPECIFIED_VALUE;

  }
  
  void setLocation(String location) {
    this.location=location;
  }

  void setMessage(String message) {
    this.message=message;
  }

  void setSeverity(String severity) {
    try{
      this.severity=Integer.parseInt(severity);
      if (this.severity!=IMarker.SEVERITY_ERROR &&
          this.severity!=IMarker.SEVERITY_WARNING &&
          this.severity!=IMarker.SEVERITY_INFO) 
       this.severity=UNSPECIFIED_VALUE;
    } catch (Exception e) {
      this.severity=UNSPECIFIED_VALUE;
    }
  }

  void setLine(String line) {
    try{
      this.line=Integer.parseInt(line);
      if (this.line<1) this.line=UNSPECIFIED_VALUE;
    } catch (Exception e) {
      this.line=UNSPECIFIED_VALUE;
    }
  }

  void setCharStart(String char_start) {
    try{
      this.char_start=Integer.parseInt(char_start);
      if (this.char_start<0) this.char_start=UNSPECIFIED_VALUE;
    } catch (Exception e) {
      this.char_start=UNSPECIFIED_VALUE;
    }
  }

  void setCharEnd(String char_end) {
    try{
      this.char_end=Integer.parseInt(char_end);
      if (this.char_end<0) this.char_end=UNSPECIFIED_VALUE;
    } catch (Exception e) {
      this.char_end=UNSPECIFIED_VALUE;
    }
  }


  IMarker getMarker(IWorkspaceRoot root) {
    try{
      if (root==null || location==null) return null;
      Path path = new Path(location);
      IFile file = root.getFileForLocation(path);
      if (file==null) return null;
      IMarker marker = file.createMarker(IMarker.PROBLEM);
      if (isSpecified(message)) marker.setAttribute(IMarker.MESSAGE,message);
      if (isSpecified(severity)) marker.setAttribute(IMarker.SEVERITY,severity);
      if (isSpecified(line)) marker.setAttribute(IMarker.LINE_NUMBER,line);
      if (isSpecified(char_start)) marker.setAttribute(IMarker.CHAR_START,char_start);
      if (isSpecified(char_end)) marker.setAttribute(IMarker.CHAR_END,char_end);
      return marker;
    } catch (Exception e) {
      return null;
    }
  }

  private boolean isSpecified(int value) {
    return !(value==UNSPECIFIED_VALUE);
  }

  private boolean isSpecified(String value) {
    return !(value==null);
  }

}