package edu.neu.ccs.demeter.daj.eclipse.internal.builder;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.IDebugEventSetListener;

class DebugEventSetListener implements IDebugEventSetListener {

  private StreamListener errorStreamListener;
  private StreamListener outStreamListener;
  private IProcess compilerProcess;
  private ILaunch launch;

  DebugEventSetListener(ILaunch launch) {
    this.launch=launch;
    compilerProcess=null;
    outStreamListener=null;
    errorStreamListener=null;
  }

  public void handleDebugEvents(DebugEvent[] events) {
    if (events==null) return;
    for (int i=0;i<events.length;i++) {
      if (events[i].getSource() instanceof IProcess &&
          launch==((IProcess)events[i].getSource()).getLaunch()) {
          IProcess process = (IProcess)events[i].getSource();

          if (events[i].getKind()==DebugEvent.CREATE && compilerProcess==null) {
              compilerProcess=process;
              outStreamListener = new StreamListener();
              errorStreamListener = new StreamListener();
              compilerProcess.getStreamsProxy().getErrorStreamMonitor().addListener(errorStreamListener);
              compilerProcess.getStreamsProxy().getOutputStreamMonitor().addListener(outStreamListener);
          }

          if (events[i].getKind()==DebugEvent.TERMINATE && process==compilerProcess) {
              compilerProcess.getStreamsProxy().getErrorStreamMonitor().removeListener(errorStreamListener);
              compilerProcess.getStreamsProxy().getOutputStreamMonitor().removeListener(outStreamListener);
              compilerProcess=null;
          }
      }
    }
  }

  StreamListener getOutputStreamListener() {
    return outStreamListener;
  }

  StreamListener getErrorStreamListener() {
    return errorStreamListener;
  }

}