package edu.neu.ccs.demeter.daj.eclipse.internal.builder;


import java.util.StringTokenizer;
import java.util.Vector;
import java.util.List;
import java.io.File;

import edu.neu.ccs.demeter.tools.daj.DAJ;
import edu.neu.ccs.demeter.tools.daj.CreateClassGraph;

public class DAJCompiler {

  public static final int NO_ERROR=0;
  public static final int TRV_SYNTAX_ERROR=1;//Cannot generate stub files -> traversal file syntax error
  public static final int JAVA_SYNTAX_ERROR=2;//AspectJ compiler error. Phrase 2 
  public static final int TRV_CLASSGRAPH_ERROR=3;//DJ raised an error while trying to walk through class graph 
  

  
  File stubDir;
  File compile1Dir;
  File outputDir;
  List javaFiles;
  List trvFiles;
  
  public DAJCompiler (String stubDir,String compile1Dir,String outputDir,List javaFiles,List trvFiles) {
    this.stubDir=new File(stubDir);
    this.compile1Dir=new File(compile1Dir);
    this.outputDir=new File(outputDir);
    this.javaFiles=convertToFiles(javaFiles);
    this.trvFiles=convertToFiles(trvFiles);
  }
  
  private List convertToFiles(List strings) {
    Vector result = new Vector(strings.size());
    for (int i=0;i<strings.size();i++) {
     try{
      result.add(new File((String)strings.get(i)));
     } catch (Exception e) {}
    }
    return result;
  }
  /**  
   * Compiles DAJ project. Returns error code if compilation failed.
   *
   */
  public int compile() {
//  try{ 

      if (!DAJ.generateStubs(trvFiles,stubDir)) {
        //as example, how I'm going to propagate errors
       try{
         System.err.println(ProblemParser.getProblemAsString(null,((File)trvFiles.get(0)).getCanonicalPath()));
       } catch (Exception e) {}
        return TRV_SYNTAX_ERROR;
      }

  //} catch (Exception e) {
//     return TRV_SYNTAX_ERROR;
//  }
//  try{ 

      if (!DAJ.compileStubs(null,trvFiles,stubDir,javaFiles,null,compile1Dir)) return JAVA_SYNTAX_ERROR;

//  } catch (Exception e) {
//     return JAVA_SYNTAX_ERROR;
//  }

    if (!runDJ()) {
      return TRV_CLASSGRAPH_ERROR;
    }

    //if (!DAJ.generateTraversal(trvFiles,compile1Dir,false,classPath,outputDir)) return TRV_CLASSGRAPH_ERROR; 
    return NO_ERROR;
  }
  
  private boolean runDJ() {
    try{
      String[] options = new String[2];
      options[0] = "-d";
      options[1] = outputDir.getCanonicalPath();
      
      String[] params = new String[trvFiles.size()+options.length];
      System.arraycopy(options,0,params,0,options.length);
      for (int i=0;i<trvFiles.size();i++) {
        params[i+options.length]=((File)trvFiles.get(i)).getCanonicalPath();
      }                                                  

     CreateClassGraph.main(params);
     return true;
    } catch (Exception e) {
     return false;
    }
  }

  public static void main(String[] argv) {
    String[] params = convertToArray(getElements(argv[0],"\n"));
    List javafiles= getElements(params[3],"|");
    List trvfiles= getElements(params[4],"|");
    DAJCompiler compiler = new DAJCompiler(params[0],params[1],params[2],javafiles,trvfiles);
    System.err.println(compiler.compile());    
  }

  public static List getElements(String args,String delim) {
    Vector result=new Vector();
    StringTokenizer st = new StringTokenizer(args,delim);
    while (st.hasMoreElements()) {
      result.add(st.nextElement());
    }
    return result;
  }
  
  public static String[] convertToArray(List arr) {
    String[] result = new String[arr.size()];
    for (int i=0;i<arr.size();i++) {
      result[i] = (String)arr.get(i);
    }
    return result;
  }
  
}