package edu.neu.ccs.demeter.daj.eclipse.internal.builder;

//JDK
import java.util.List;
import java.util.Vector;
import java.util.Stack;
import java.util.Map;
import java.io.File;
import java.io.FileReader;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.io.PrintStream;

//Eclipse core
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.resources.IMarker;

//Plugin 
import edu.neu.ccs.demeter.daj.eclipse.internal.core.DAJUtils;
import edu.neu.ccs.demeter.daj.eclipse.DAJPlugin;

//Debug plugin
import org.eclipse.debug.core.DebugPlugin;

import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.Launch;


//JDT API
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

//DAJ API
import edu.neu.ccs.demeter.tools.daj.DAJ;

public class Builder extends IncrementalProjectBuilder {
  public static String COMPILER_CLASS="edu.neu.ccs.demeter.daj.eclipse.internal.builder.DAJCompiler";

    public static void main(String[] args) {
      //YEAH!!!!
    } 

  protected IProject[] build(int kind, Map argmap, IProgressMonitor monitor) {
     main(null);
    //We want to perform ONLY FULL BUILDS (just like AspectJ plugin)
    if (kind!=IncrementalProjectBuilder.FULL_BUILD) return null;
    PrintStream err = System.err;
    PrintStream out = System.out;
    //Debug...
     try{
       //System.setErr(new java.io.PrintStream(new java.io.FileOutputStream("result.err")));
       //System.setOut(new java.io.PrintStream(new java.io.FileOutputStream("result.out")));
     } catch (Exception e) {}

    try{
      
      IProject project=getProject();
      //Delete markers
      project.deleteMarkers( IMarker.PROBLEM, true, IResource.DEPTH_INFINITE );

      //Then we need to grasp all the information we need to compile
      //All the information DAJ compiler needs is:
      // - directory to place generated stub files to  
      // - directory to place compiled stub classes to
      // - destination directory for generated Traversals
      // - traversal files
      // - project (java/ajc) files

      // - stub generation phrase output dir
      String stubDir = prepareProjectStubDir(project);

      // - stub compilation phrase output dir
      String compile1Dir = prepareProjectCompile1Dir(project);

      // - traversal generation phrase output dir
      String outputDir = prepareOutputDir(project);

      // - project "java/ajc" files
      String[] javaFileExts = {"java","ajc"};
      String[] javafiles=DAJUtils.getProjectFiles(project,javaFileExts,true);
      if (javafiles==null || javafiles.length==0) return null;

      // - project "trv" files
      String[] dajFileExts = {"trv"};
      String[] trvfiles=DAJUtils.getProjectFiles(project,dajFileExts,false);
      if (trvfiles==null || trvfiles.length==0) return null;

      //At this point we are ready to compile the whole thing.
      //We'll do this by running new JVM. 
      //We MUST build classpaths for this JVM as:
      //project classpath + libs + compile1Dir
      String[] projectClassPath=DAJUtils.getClassPath(project);
      if (projectClassPath==null) projectClassPath=new String[0];
      String[] libClassPath=getLibClassPaths();
      if (libClassPath==null) libClassPath=new String[0];
      String[] classPath = new String[libClassPath.length+projectClassPath.length+1];
      classPath[0] = compile1Dir;
      System.arraycopy(libClassPath,0,classPath,1,libClassPath.length);
      System.arraycopy(projectClassPath,0,classPath,libClassPath.length+1,projectClassPath.length);

      //We must communicate with compiler via command line options - new JVM...:-((
      //Simple mechanism:
      //All the different parts are separated via \n
      //Array elements within the same part are separated via |
      StringBuffer args = new StringBuffer();
      args=args.append(stubDir).append("\n").append(compile1Dir).append("\n").append(outputDir).append("\n");
      args=args.append(convertArrayToString(javafiles,"|")).append("\n").append(convertArrayToString(trvfiles,"|"));
      String[] arguments = new String[1];
      arguments[0] = args.toString();

      //Setup configuration to run compiler class in separate JVM...
      IVMRunner runner = JavaRuntime.getDefaultVMInstall().getVMRunner(ILaunchManager.RUN_MODE);
      VMRunnerConfiguration conf = new VMRunnerConfiguration(COMPILER_CLASS,classPath);
      if (arguments!=null) conf.setProgramArguments(arguments);
      conf.setWorkingDirectory(project.getLocation().makeAbsolute().toOSString());
      final ILaunch launch=new Launch(null,ILaunchManager.RUN_MODE,null);

      //Since we want to "listen" output/error streams we need to 
      //add some kind of listener to this stuff...
      DebugPlugin dpl = DebugPlugin.getDefault();

      DebugEventSetListener del = new DebugEventSetListener(launch);

      dpl.addDebugEventListener(del);

      runner.run(conf,launch,null);

      //ILaunch launch=DAJUtils.runJVM("edu.neu.ccs.demeter.daj.eclipse.internal.builder.DAJCompiler",classPath,arguments);

      while (!launch.isTerminated()) {
        Thread.sleep(500);
      }
      dpl.removeDebugEventListener(del);


      
      
      String exitCode = getCompilerExitCode(del.getErrorStreamListener());

      if (exitCode.equals("0")) {
        saveBuildResults(project,trvfiles,outputDir);
      } else {
        saveBuildResults(project,new String[0],outputDir);
        List problems = getProblems(del.getErrorStreamListener().getMessagesStack());

        showProblems(problems,project);
        if (exitCode.equals("1")) {
          throw new OperationCanceledException("Traversal file syntax error.");
        }
        if (exitCode.equals("3")) {
          throw new OperationCanceledException("Error while creating class graph.");
        }
      }

      
      //System.out.println("content:"+del.getErrorStreamListener().getStreamContent());
    }  
     catch (Exception e) {
       if (e instanceof OperationCanceledException) {
         //System.setErr(err);
         //System.setOut(out);
         throw (OperationCanceledException)e;
       } else {
         e.printStackTrace();
       }
     }
     finally { 
       //System.setErr(err);
       //System.setOut(out);
     }
    return null;
  }


  private List getProblems(List messages) {
    Vector problems = new Vector();
    if (messages!=null) {
      for (int i=0;i<messages.size();i++) {
        System.err.println("message:"+(String)messages.get(i));
        Problem problem=ProblemParser.getProblem((String)messages.get(i));
        System.err.println("problem:"+problem);
        if (problem!=null) problems.add(problem);
      } 
    }
    return problems;
  }

  private List showProblems(List problems,IProject project) {
    Vector markers = new Vector();
    try{
      IWorkspaceRoot root = project.getWorkspace().getRoot(); 
      for (int i=0;i<problems.size();i++) {
         IMarker marker=((Problem)problems.get(i)).getMarker(root);
         System.err.println("marker:"+marker);
         if (marker!=null) markers.add(marker);
      }
    } catch (Exception e) {}
    return markers;
  }

  private String getCompilerExitCode(StreamListener listener) {
    return listener.getLastAppended();
  }


  private String prepareProjectStubDir(IProject project) throws Exception {
     String projectName = project.getName();
     File stubfolder = DAJPlugin.getStateStubPath(projectName).makeAbsolute().toFile();
     if (stubfolder.exists()) {
       deleteContent(stubfolder);
     }
      stubfolder.mkdirs();
      return stubfolder.getCanonicalPath();
  }

  private String prepareProjectCompile1Dir(IProject project) throws Exception {
     String projectName = project.getName();
     File folder = DAJPlugin.getStateCompiled1Path(projectName).makeAbsolute().toFile();
     if (folder.exists()) {
       deleteContent(folder);
     }
      folder.mkdirs();
      return folder.getCanonicalPath();
  }

  private String prepareOutputDir(IProject project) throws Exception {
    cleanPreviousBuildResult(project);
    return project.getLocation().toOSString();
  }

  private void deleteContent(File file) {
   if (!file.exists()) return;
   try{
    if (file.isDirectory()) {
      File[] subs = file.listFiles();
      if (subs!=null) 
        for (int i=0;i<subs.length;i++)
          deleteContent(subs[i]);
    }
    file.delete();
   } catch (Exception e) {}
  }

  //Removes all the files generated as the result of the last build
  private void cleanPreviousBuildResult(IProject project) {
    File lbf = DAJPlugin.getLastBuildInfoFolder(project.getName()).addTrailingSeparator().append("result.lst").makeAbsolute().toFile();
    try{
      if (!lbf.exists()) {
        lbf.getParentFile().mkdirs();
        return;
      } else {
        String projectFolder = project.getLocation().makeAbsolute().toOSString();
        BufferedReader reader = new BufferedReader(new FileReader(lbf));
        String line;
        while ((line=reader.readLine())!=null) {
          try{
            if (line.startsWith(projectFolder)) {
              line = line.substring(projectFolder.length());
              if (line.startsWith(File.separator)) line=line.substring(1);
              project.getFile(line).delete(true,null);
            } else {
              new File(line).delete();
            }

          } catch (Exception ex) {
            ex.printStackTrace();
          }
        }                           
        lbf.delete();
      }
    } catch (Exception e) {}
  }

  //Saves results of the previous build (generated traversal aspect file names)
  private void saveBuildResults(IProject project,String[] trvfiles,String outputDir) {
    String projectFolder = project.getLocation().makeAbsolute().toOSString();
    try{
      Vector trvFiles = new Vector(trvfiles.length);
      for (int i=0;i<trvfiles.length;i++) {
        trvFiles.add(new File(trvfiles[i]));
      }
      List aspects = DAJ.getGeneratedFiles(trvFiles,new File(outputDir));
      File lbf = DAJPlugin.getLastBuildInfoFolder(project.getName()).addTrailingSeparator().append("result.lst").makeAbsolute().toFile();
      PrintWriter writer = new PrintWriter(new FileOutputStream(lbf));
      try{
        for (int i=0;i<aspects.size();i++) {
          String fileName = ((File)aspects.get(i)).getCanonicalPath();
          writer.println(fileName);
          try{
            if (fileName.startsWith(projectFolder)) {
              fileName = fileName.substring(projectFolder.length());
              if (fileName.startsWith(File.separator)) fileName=fileName.substring(1);
               project.getFile(fileName).refreshLocal(IResource.DEPTH_ZERO,null);
            }
          } catch (Exception ex) {}
        }
      } finally {writer.close();}
    } catch (Exception e) {
    }
  }

  //Constructs separated string from array given
  private String convertArrayToString(String[] arr,String separator) {
     StringBuffer sb = new StringBuffer();
     for (int i=0;i<arr.length;i++)
      sb=sb.append(arr[i]).append(separator);
     return sb.toString();
  }

  private String[] getLibClassPaths() {
    String[] classPath=new String[7];
    classPath[0] = getLibJarPath("daj.jar");
    classPath[1] = getLibJarPath("aspectjrt.jar");
    classPath[2] = getLibJarPath("demeterj.jar");
    classPath[3] = getLibJarPath("rt.jar");
    classPath[4] = getLibJarPath("");
    classPath[5] = getLibJarPath("aspectjtools.jar");
    classPath[6] = getLibJarPath("dajplug.jar");
    return classPath;
  }


  private String getLibJarPath(String name) {
    IPath statePath=DAJPlugin.getStateLibPath().addTrailingSeparator().append(name);
    return statePath.makeAbsolute().toOSString();
  }

  
}
