package edu.neu.ccs.demeter.daj.eclipse;

import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.dialogs.*;
import org.eclipse.jface.text.source.*;
import org.eclipse.jface.text.*;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;

public class EditorPart extends org.eclipse.ui.editors.text.TextEditor {

       class SelectionChangedListener implements ISelectionChangedListener {
         public void selectionChanged(SelectionChangedEvent event) {
           if (event.getSelection() instanceof IStructuredSelection) {
             Object first=((IStructuredSelection)event.getSelection()).getFirstElement();
             if (first instanceof java.util.Hashtable) {
                if (((java.util.Hashtable)first).get("line")!=null && ((java.util.Hashtable)first).get("line") instanceof Integer) {
                  selectLine(((Integer)((java.util.Hashtable)first).get("line")).intValue());
                }
             }
           }
         }
       }
       class FocusListener extends FocusAdapter {
         public void focusGained(FocusEvent e) {
           focusOn();
         }
         public void focusLost(FocusEvent e) {
           focusOff();
         }
       }

  protected ContentOutlinePage fContentOutlinePage=null;
  private SelectionChangedListener listener=null;
  private FocusListener focusListener=null;
  private int selectedLine=-1;
  private Color white=null;
  private Color red=null;
  
  public void createPartControl(Composite parent) {
    super.createPartControl(parent);
    white=getSourceViewer().getTextWidget().getBackground();
    red=new Color(parent.getDisplay(),100,0,0);
    focusListener=new FocusListener();
    getSourceViewer().getTextWidget().addFocusListener(focusListener);
  }
  protected ContentOutlinePage createContentOutlinePage() {
    ContentOutlinePage page=null;
    page = new ContentOutlinePage(getSourceViewer().getTextWidget().getText());
    listener=new SelectionChangedListener();
    /*Registering editor as listener for selection changes 
      within page (it's also cover selection changes in
      content outline view
     */
    page.addSelectionChangedListener(listener);
    return page;
  }


  public Object getAdapter(Class adapterClass) {
   if (IContentOutlinePage.class.equals(adapterClass)) { 
     if (fContentOutlinePage==null) 
     fContentOutlinePage=createContentOutlinePage();

     /*
      * Registering fContentOutlinePage as listener for text events changing
      */
     getSourceViewer().addTextListener(
        new ITextListener() {
          public void textChanged(TextEvent event)  {
            fContentOutlinePage.setInput(getSourceViewer().getTextWidget().getText());
          }
        }
     );
     return fContentOutlinePage;
   } 
   return null;
  }

  public void dispose() {
    if (listener!=null || fContentOutlinePage!=null) 
      fContentOutlinePage.removeSelectionChangedListener(listener);
    if (red!=null) 
      red.dispose();
    super.dispose();
  }


  private void selectLine(int index) {
    if (index>=0) {
     getSourceViewer().setTopIndex(index);
     if (selectedLine>=0) getSourceViewer().getTextWidget().setLineBackground(selectedLine,1,white);
     getSourceViewer().getTextWidget().setLineBackground(index,1,red);
     selectedLine=index;
    }
  }
  private void focusOn() {
    if (selectedLine>=0) getSourceViewer().getTextWidget().setLineBackground(selectedLine,1,white);
  }
  private void focusOff() {
    if (selectedLine>=0) getSourceViewer().getTextWidget().setLineBackground(selectedLine,1,red);
  }

}
