package edu.neu.ccs.demeter.daj.eclipse;

import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.ajdt.ui.AspectJPlugin;
import org.eclipse.core.runtime.Status;


/**
 * The DAJ project nature adds daj build mechanism to given project
 */

public class DAJProjectNature implements IProjectNature {
 private IProject project;

 /**
  *Adds DAJ project builder to the project (on the top of the builders list)
  */
 public void configure() throws CoreException {
  
   IProjectDescription projectDescription=project.getDescription();
   ICommand[] buildCommands=projectDescription.getBuildSpec();
   if (hasBuilder(buildCommands,DAJPlugin.BUILDER_ID)) return;

   if (!hasBuilder(buildCommands,AspectJPlugin.ID_BUILDER)) {
    throw new CoreException(
       new Status(Status.WARNING,DAJPlugin.ID,0,"No AspectJBuilder defined for the given project",new Exception())
    );
   } 

   ICommand command=projectDescription.newCommand();
   command.setBuilderName(DAJPlugin.BUILDER_ID);
   ICommand[] newcomm=new ICommand[buildCommands.length+1];
   System.arraycopy(buildCommands,0,newcomm,1,buildCommands.length);
   newcomm[0]=command;
   projectDescription.setBuildSpec(newcomm);
   project.setDescription(projectDescription,null);
  
 }

 /**
  *Removes DAJ builder from the list of the project builders
  */

 public void deconfigure() throws CoreException {

   IProjectDescription projectDescription=project.getDescription();
   ICommand[] buildCommands=projectDescription.getBuildSpec();
   if (!hasBuilder(buildCommands,DAJPlugin.BUILDER_ID)) return;
   ICommand[] newcomm=new ICommand[buildCommands.length-1];
   int j=0;
   for (int i=0;i<buildCommands.length;i++) 
    if (!buildCommands[i].getBuilderName().equals(DAJPlugin.BUILDER_ID)) {
     newcomm[j]=buildCommands[i];
     j++;
    }
   projectDescription.setBuildSpec(newcomm);
   project.setDescription(projectDescription,null);   

 }
 /**
  * @see IProjectNature#setProject
  */
 public void setProject(IProject project) {
   this.project=project;
 }
 /**
  * @see IProjectNature#getProject
  */
 public IProject getProject() {
   return project;
 }

 /**
  * Returns if given ICommand array contains given builderID
  */
 private boolean hasBuilder(ICommand[] commands,String builderID) {
   boolean result=false;
   for (int i=0;i<commands.length;i++) 
     if (commands[i].getBuilderName().equals(builderID)) {
       result=true;
       break;
     }
   return result;
 }

}