package edu.neu.ccs.demeter.daj.eclipse;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.resources.IProject;

public class DAJPlugin extends org.eclipse.core.runtime.Plugin {

   private static DAJPlugin instance=null;
   public static final String ID = "edu.neu.ccs.demeter.daj.eclipse";
   public static final String NATURE_ID = ID + ".dajnature";
   public static final String BUILDER_ID = ID + ".dajbuilder";

   //Place inside state dir where lib files located
   public static final String LIB_STATE_PREFIX = "";
   //Place inside Plugin dir where lib files located
   public static final String LIB_PLUGIN_PREFIX = "";
   //Place inside state/projectName dir where stub files placed
   public static final String PROJECT_STUB_PREFIX = "stubs";
   //Place inside state/projectName dir where stub files placed
   public static final String PROJECT_COMPILE_1_PREFIX = "compile1";
   //Folder inside project state folder we want to keep 
   //last build generated files list in:
   public static final String PROJECT_LAST_BUILD_LIST_PREFIX = "lastBuild";
   
   //Folder inside project dir where to place files generated by DJ
   public static final String DJ_GENERATED_FILES_PREFIX = "";
   public static DAJPlugin getInstance() {return instance;}

    public DAJPlugin(org.eclipse.core.runtime.IPluginDescriptor descriptor) {
      super(descriptor);
      instance = this;
    }

    public static DAJPlugin getDefault() {
    	return instance;
    }

    public static org.eclipse.core.resources.IWorkspace getWorkspace() {
    	return org.eclipse.core.resources.ResourcesPlugin.getWorkspace();
    }

    //Specially for testing with Pauls LoDChecker plugin
    public static void main(String[] args) {
      //YEAH!!!!
    }   
    /**
     * Copies jar files into state location if they are not there
     */
    public void startup() {
      copyFileIfNotExists("demeterj.jar","demeterj.jar");
      copyFileIfNotExists("aspectjtools.jar","aspectjtools.jar");
      copyFileIfNotExists("aspectjrt.jar","aspectjrt.jar");
      copyFileIfNotExists("rt.jar","rt.jar");
      copyFileIfNotExists("daj.jar","daj.jar");        
      copyFileIfNotExists("dajplug.jar","dajplug.jar");        
      main(null);
    }

    private void copyFileIfNotExists(String pluginfile,String statefile) {
      try{
        IPath plugPath=getPluginLibPath(pluginfile);
        IPath statePath = getStateLibPath().addTrailingSeparator().append(statefile);

        File receiver = statePath.toFile(); 
        if (!receiver.exists()) {
          FileOutputStream out = new FileOutputStream(receiver);
          try{
            InputStream in = openStream(plugPath);
            try{
              byte[] buff = new byte[10240];
              int read=0;
              while ((read=in.read(buff))>=0) {
                out.write(buff,0,read);
              }
            } finally {
              in.close();
            }
          } finally {
            out.close();
          }
        }
      } catch (Exception e) {}
    }

   public static IPath getStatePath() {
      Plugin plug = Platform.getPlugin(ID);
      return plug.getStateLocation();
   }

   public static IPath getStateLibPath() {
      IPath state = getStatePath();
      if (LIB_STATE_PREFIX.length()>0) {
	return state.addTrailingSeparator().append(LIB_STATE_PREFIX);
      } else {
       return state;
      }
   }

   public static IPath getPluginLibPath(String fileName) {
      IPath result = new Path(LIB_PLUGIN_PREFIX);

      if (LIB_PLUGIN_PREFIX.length()==0) return result.append(fileName);

      if (fileName.length()>0) {
	return result.addTrailingSeparator().append(fileName);
      } else {
       return result;
      }
   }

   public static IPath getStateStubPath(String projectName) {
      IPath state = getStatePath();
      if (PROJECT_STUB_PREFIX.length()>0) {
	return state.addTrailingSeparator().append(projectName).addTrailingSeparator().append(PROJECT_STUB_PREFIX);
      } else {
       return state.addTrailingSeparator().append(projectName);
      }
   }

   public static IPath getLastBuildInfoFolder(String projectName) {
      IPath state = getStatePath();
      if (PROJECT_LAST_BUILD_LIST_PREFIX.length()>0) {
	return state.addTrailingSeparator().append(projectName).addTrailingSeparator().append(PROJECT_LAST_BUILD_LIST_PREFIX);
      } else {
       return state.addTrailingSeparator().append(projectName);
      }
   }



   public static IPath getStateCompiled1Path(String projectName) {
      IPath state = getStatePath();
      if (PROJECT_COMPILE_1_PREFIX.length()>0) {
	return state.addTrailingSeparator().append(projectName).addTrailingSeparator().append(PROJECT_COMPILE_1_PREFIX);
      } else {
       return state.addTrailingSeparator().append(projectName);
      }
   }
   /**
    * Returns relative (to project dir) path of DJ output dir
    */
   public static IPath getDJOutputDir(IProject project) {
      /* Absolute version
      IPath projdir = project.getLocation();
      if (DJ_GENERATED_FILES_PREFIX.length()>0) {
	return projdir.addTrailingSeparator().append(DJ_GENERATED_FILES_PREFIX).makeAbsolute();
      } else {
       return projdir.makeAbsolute();
      }
      */
      return new Path(DJ_GENERATED_FILES_PREFIX);
   }

}
