package edu.neu.ccs.demeter.daj.eclipse;
import org.eclipse.swt.widgets.*;
import org.eclipse.jface.viewers.*;
import org.eclipse.core.runtime.*;
import org.eclipse.jface.dialogs.*;
import org.eclipse.core.resources.*;

public class ContentOutlinePage extends org.eclipse.ui.views.contentoutline.ContentOutlinePage {
  private TreeViewer tree;
  private ContentProvider cp;
  private LabelProvider lp;
  private Object input;

  public ContentOutlinePage(Object input) {
    this.input=input;
  }
  
  public void createControl(Composite parent) {
    super.createControl(parent);
    tree=getTreeViewer();
    cp=new ContentProvider();
    lp=new LabelProvider();
    tree.setContentProvider(cp);
    tree.setLabelProvider(lp); 
    setInput(input);
  }

  public void setInput(Object input) {
    this.input=input;
    tree.setInput(DAJModelFactory.getContentOutline(input));
  }

 protected  void fireSelectionChanged(ISelection selection)  {
   super.fireSelectionChanged(selection);
 }


}