package edu.neu.ccs.demeter.daj.eclipse;

import java.util.Vector;
import java.util.Iterator;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.ajdt.ui.AspectJPlugin;

import org.eclipse.jface.dialogs.*;
/**
 * The action is called from pop-up menu on a project having AspectJ nature and 
 * doesn't have an DAJ nature. 
 */
public class AddDAJNatureAction implements IObjectActionDelegate {

	private IWorkbenchPart targetPart;
	private Vector selected = new Vector();

	/**
	 * @see IActionDelegate#run(IAction)
	 */
	public void run(IAction arg0) {
        	for (Iterator iter = selected.iterator(); iter.hasNext();) {
        		IProject project = (IProject) iter.next();
        		try {				
        			// add the DAJ Nature
        			IProjectDescription description = project.getDescription();
        			String[] prevNatures = description.getNatureIds();
        			String[] newNatures = new String[prevNatures.length + 1];
        			System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        			newNatures[prevNatures.length] = DAJPlugin.NATURE_ID;
        			description.setNatureIds(newNatures);
        			project.setDescription(description, null);
        		} catch (CoreException e) {
                          MessageDialog.openInformation(targetPart.getSite().getShell(),"ContentOutlinePage",e.getMessage()); 
        		}

        	}
	}

	/**
         *  From IActionDelegate - set the availability or otherwise of this
	 * action.
	 */
	public void selectionChanged(IAction action, ISelection sel) {
		selected.clear();
		boolean enable = true;
		if (sel instanceof IStructuredSelection) {
			IStructuredSelection selection = (IStructuredSelection) sel;
			for (Iterator iter = selection.iterator(); iter.hasNext();) {
				Object object = iter.next();
				if (object instanceof IJavaProject) {
					object = ((IJavaProject) object).getProject();
				}
				if (object instanceof IProject) {
					IProject project = (IProject) object;
					try {
						if (!project.isOpen() || 
                                                    !project.hasNature(AspectJPlugin.ID_NATURE) ||
                                                     project.hasNature(DAJPlugin.NATURE_ID)
 						    ) {
							enable = false;
							break;
						} else {
							selected.add(project);
						}
					} catch (CoreException e) {
						; // do something!
					}
				} else {
					enable = false;
					break;
				}
			}
			action.setEnabled(enable);
		}
	}

	/**
	 * From IObjectActionDelegate
	 */
	public void setActivePart(IAction action, IWorkbenchPart targetPart) {
		this.targetPart = targetPart;
	}

}