/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.tools.daj;

import edu.neu.ccs.demeter.Ident;
import edu.neu.ccs.demeter.tools.daj.Argument;
import edu.neu.ccs.demeter.tools.daj.AspectDecl_List;
import edu.neu.ccs.demeter.tools.daj.AspectName;
import edu.neu.ccs.demeter.tools.daj.ClassGraphSliceDecl;
import edu.neu.ccs.demeter.tools.daj.ClassGraphVar;
import edu.neu.ccs.demeter.tools.daj.ClassGraphVarDecl;
import edu.neu.ccs.demeter.tools.daj.ClassName;
import edu.neu.ccs.demeter.tools.daj.CopyVisitor;
import edu.neu.ccs.demeter.tools.daj.DefaultClassGraphDecl;
import edu.neu.ccs.demeter.tools.daj.DisplayVisitor;
import edu.neu.ccs.demeter.tools.daj.EqualVisitor;
import edu.neu.ccs.demeter.tools.daj.MethodName;
import edu.neu.ccs.demeter.tools.daj.MyClassGraphListener;
import edu.neu.ccs.demeter.tools.daj.Nonempty_Argument_CommaList;
import edu.neu.ccs.demeter.tools.daj.Nonempty_TraversalAspect_ListL;
import edu.neu.ccs.demeter.tools.daj.Nonempty_VisitorMethod_LineList;
import edu.neu.ccs.demeter.tools.daj.ReturnType;
import edu.neu.ccs.demeter.tools.daj.StreamConnector;
import edu.neu.ccs.demeter.tools.daj.SubgraphVisitor;
import edu.neu.ccs.demeter.tools.daj.TraceVisitor;
import edu.neu.ccs.demeter.tools.daj.TraversalAspect;
import edu.neu.ccs.demeter.tools.daj.TraversalDecl;
import edu.neu.ccs.demeter.tools.daj.TraversalDeclOptions;
import edu.neu.ccs.demeter.tools.daj.TraversalStrategy;
import edu.neu.ccs.demeter.tools.daj.TraversalVar;
import edu.neu.ccs.demeter.tools.daj.UniversalVisitor;
import edu.neu.ccs.demeter.tools.daj.VisitorClass;
import edu.neu.ccs.demeter.tools.daj.VisitorDecl;
import edu.neu.ccs.demeter.tools.daj.VisitorMethod;
import edu.neu.ccs.demeter.tools.daj.VisitorMethod_LineList;
import edu.neu.ccs.demeter.tools.daj.VisitorVar;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Hashtable;

class PrintVisitor
extends UniversalVisitor {
    protected int indent;
    protected boolean needSpace;
    protected PrintWriter out = new PrintWriter(System.out, true);

    public int get_indent() {
        return this.indent;
    }

    public void set_indent(int new_indent) {
        this.indent = new_indent;
    }

    public boolean get_needSpace() {
        return this.needSpace;
    }

    public void set_needSpace(boolean new_needSpace) {
        this.needSpace = new_needSpace;
    }

    public PrintVisitor() {
    }

    public PrintVisitor(int indent, boolean needSpace) {
        this.set_indent(indent);
        this.set_needSpace(needSpace);
    }

    PrintWriter get_out() {
        return this.out;
    }

    void set_out(PrintWriter new_out) {
        this.out = new_out;
    }

    PrintVisitor(PrintWriter out) {
        this.set_out(out);
    }

    PrintVisitor(PrintStream out) {
        this.set_out(new PrintWriter(out, true));
    }

    public void finish() {
        this.out.flush();
    }

    protected void space() {
        if (this.needSpace) {
            this.out.print(" ");
        }
        this.needSpace = false;
    }

    public void before_aspectname(TraversalAspect source, AspectName dest) {
        this.space();
        this.out.print("aspect");
        this.needSpace = true;
    }

    public void before_aspectdecl_list(TraversalAspect source, AspectDecl_List dest) {
        this.out.print("{");
        this.needSpace = false;
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
    }

    public void after_aspectdecl_list(TraversalAspect source, AspectDecl_List dest) {
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
        this.out.print("}");
        this.needSpace = false;
        this.out.println();
        int i2 = 0;
        while (i2 < this.indent) {
            this.out.print("\t");
            ++i2;
        }
        this.needSpace = false;
    }

    public void before_tv(TraversalDecl source, TraversalVar dest) {
        this.space();
        this.out.print("declare");
        this.needSpace = true;
        this.space();
        this.out.print("traversal");
        this.needSpace = true;
    }

    public void before_ts(TraversalDecl source, TraversalStrategy dest) {
        this.out.print(":");
        this.needSpace = false;
    }

    public void after_ts(TraversalDecl source, TraversalStrategy dest) {
        this.out.print(";");
        this.needSpace = false;
    }

    public void before_cgvar(TraversalDeclOptions source, ClassGraphVar dest) {
        this.out.print("(");
        this.needSpace = false;
    }

    public void before_visitorvar(TraversalDeclOptions source, VisitorVar dest) {
        this.out.print(",");
        this.needSpace = false;
    }

    public void after(TraversalDeclOptions host) {
        this.out.print(")");
        this.needSpace = false;
    }

    public void before_i(TraversalVar source, Ident dest) {
        this.space();
        this.out.print(source.get_i());
        this.needSpace = true;
    }

    public void before_s(TraversalStrategy source, String dest) {
        this.space();
        this.out.print("\"" + source.get_s() + "\"");
        this.needSpace = true;
    }

    public void before_visitorvar(VisitorDecl source, VisitorVar dest) {
        this.space();
        this.out.print("Visitor");
        this.needSpace = true;
    }

    public void after_visitorvar(VisitorDecl source, VisitorVar dest) {
        this.out.print(";");
        this.needSpace = false;
    }

    public void before_ident(VisitorVar source, Ident dest) {
        this.space();
        this.out.print(source.get_ident());
        this.needSpace = true;
    }

    public void before_aname(AspectName source, Ident dest) {
        this.space();
        this.out.print(source.get_aname());
        this.needSpace = true;
    }

    public void before_cgName(ClassGraphVar source, Ident dest) {
        this.space();
        this.out.print(source.get_cgName());
        this.needSpace = true;
    }

    public void before_cgvar(ClassGraphVarDecl source, ClassGraphVar dest) {
        this.space();
        this.out.print("ClassGraph");
        this.needSpace = true;
    }

    public void after_vardecl(DefaultClassGraphDecl source, ClassGraphVarDecl dest) {
        this.out.print(";");
        this.needSpace = false;
    }

    public void before_supercg(ClassGraphSliceDecl source, Ident dest) {
        this.out.print("=");
        this.needSpace = false;
        this.space();
        this.out.print("new");
        this.needSpace = true;
        this.space();
        this.out.print("ClassGraph");
        this.needSpace = true;
        this.out.print("(");
        this.needSpace = false;
        this.space();
        this.out.print(source.get_supercg());
        this.needSpace = true;
    }

    public void before_ts(ClassGraphSliceDecl source, TraversalStrategy dest) {
        this.out.print(",");
        this.needSpace = false;
    }

    public void after_ts(ClassGraphSliceDecl source, TraversalStrategy dest) {
        this.out.print(")");
        this.needSpace = false;
        this.out.print(";");
        this.needSpace = false;
    }

    public void before_cgHash(MyClassGraphListener source, Hashtable dest) {
        this.space();
        this.out.print(source.get_cgHash());
        this.needSpace = true;
    }

    public void before_classname(VisitorClass source, ClassName dest) {
        this.space();
        this.out.print("class");
        this.needSpace = true;
    }

    public void before_visitormethod_linelist(VisitorClass source, VisitorMethod_LineList dest) {
        this.out.print(" ");
        this.needSpace = false;
        this.out.print("{");
        this.needSpace = false;
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
    }

    public void after_visitormethod_linelist(VisitorClass source, VisitorMethod_LineList dest) {
        this.out.print("}");
        this.needSpace = false;
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
    }

    public void after_methodname(VisitorMethod source, MethodName dest) {
        this.out.print("(");
        this.needSpace = false;
    }

    public void after(VisitorMethod host) {
        this.out.print(")");
        this.needSpace = false;
        this.out.print(";");
        this.needSpace = false;
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
    }

    public void before_ident(MethodName source, Ident dest) {
        this.space();
        this.out.print(source.get_ident());
        this.needSpace = true;
    }

    public void before_ident(ReturnType source, Ident dest) {
        this.space();
        this.out.print(source.get_ident());
        this.needSpace = true;
    }

    public void before_ident(Argument source, Ident dest) {
        this.space();
        this.out.print(source.get_ident());
        this.needSpace = true;
    }

    public void before_ident(ClassName source, Ident dest) {
        this.space();
        this.out.print(source.get_ident());
        this.needSpace = true;
    }

    public void before_src(StreamConnector source, InputStream dest) {
        this.space();
        this.out.print(source.get_src());
        this.needSpace = true;
    }

    public void before_target(StreamConnector source, OutputStream dest) {
        this.space();
        this.out.print(source.get_target());
        this.needSpace = true;
    }

    public void before_indent(PrintVisitor source, int dest) {
        this.space();
        this.out.print(source.get_indent());
        this.needSpace = true;
    }

    public void before_needSpace(PrintVisitor source, boolean dest) {
        this.space();
        this.out.print(source.get_needSpace());
        this.needSpace = true;
    }

    public void before_copy(CopyVisitor source, Object dest) {
        this.space();
        this.out.print(source.get_copy());
        this.needSpace = true;
    }

    public void before_is_equal(SubgraphVisitor source, boolean dest) {
        this.space();
        this.out.print(source.get_is_equal());
        this.needSpace = true;
    }

    public void before_is_equal(EqualVisitor source, boolean dest) {
        this.space();
        this.out.print(source.get_is_equal());
        this.needSpace = true;
    }

    public void before_indent(DisplayVisitor source, int dest) {
        this.space();
        this.out.print(source.get_indent());
        this.needSpace = true;
    }

    public void before_indent(TraceVisitor source, int dest) {
        this.space();
        this.out.print(source.get_indent());
        this.needSpace = true;
    }

    public void before_next(Nonempty_TraversalAspect_ListL source, Nonempty_TraversalAspect_ListL dest) {
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
    }

    public void after_next(Nonempty_VisitorMethod_LineList source, Nonempty_VisitorMethod_LineList dest) {
        this.out.println();
        int i = 0;
        while (i < this.indent) {
            this.out.print("\t");
            ++i;
        }
        this.needSpace = false;
    }

    public void before_next(Nonempty_Argument_CommaList source, Nonempty_Argument_CommaList dest) {
        this.out.print(",");
        this.needSpace = false;
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        super.universal_trv0_bef(_v_);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        super.universal_trv0_aft(_v_);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        super.universal_trv0(_v_);
        this.universal_trv0_aft(_v_);
    }
}

