/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.tools.daj;

import edu.neu.ccs.demeter.dj.ClassGraph;
import edu.neu.ccs.demeter.tools.daj.AspectJTraversal;
import edu.neu.ccs.demeter.tools.daj.ClassGraphListener;
import edu.neu.ccs.demeter.tools.daj.DAJ;
import edu.neu.ccs.demeter.tools.daj.ParseException;
import edu.neu.ccs.demeter.tools.daj.Parser;
import edu.neu.ccs.demeter.tools.daj.TraversalAspectList;
import edu.neu.ccs.demeter.tools.daj.UniversalVisitor;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.Hashtable;

class MyClassGraphListener
extends ClassGraphListener {
    protected Hashtable cgHash;

    public Hashtable get_cgHash() {
        return this.cgHash;
    }

    public void set_cgHash(Hashtable new_cgHash) {
        this.cgHash = new_cgHash;
    }

    public MyClassGraphListener() {
    }

    public MyClassGraphListener(Hashtable cgHash) {
        this.set_cgHash(cgHash);
    }

    public static MyClassGraphListener parse(Reader in) throws ParseException {
        return new Parser(in)._MyClassGraphListener();
    }

    public static MyClassGraphListener parse(InputStream in) throws ParseException {
        return new Parser(in)._MyClassGraphListener();
    }

    public static MyClassGraphListener parse(String s) {
        try {
            return MyClassGraphListener.parse(new StringReader(s));
        }
        catch (ParseException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void ClassGraphEvent(String[] args, ClassGraph cg) {
        File dir = null;
        boolean generateStubs = false;
        int x = 0;
        while (x < args.length) {
            try {
                if (args[x].equals("-d")) {
                    dir = new File(args[++x]);
                } else if (args[x].equals("-stub")) {
                    generateStubs = true;
                } else if (args[x].equals("-gpa")) {
                    AspectJTraversal.addPrintingAdvice = true;
                } else if (args[x].equals("-ajtdebug")) {
                    AspectJTraversal.debug = true;
                    AspectJTraversal.debug2 = true;
                } else {
                    BufferedReader in = new BufferedReader(new FileReader(args[x]));
                    TraversalAspectList tal = TraversalAspectList.parse(in);
                    if (generateStubs) {
                        tal.generateStubs(dir, DAJ.getRootName(args[x]));
                    } else {
                        tal.processClassGraphTraversals(cg, dir);
                    }
                }
            }
            catch (ParseException ex) {
                System.out.println(ex);
                ex.printStackTrace(System.out);
            }
            catch (IOException ex) {
                System.out.println(ex);
                ex.printStackTrace(System.out);
            }
            ++x;
        }
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        super.universal_trv0_bef(_v_);
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
        super.universal_trv0_aft(_v_);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        _v_.before_cgHash(this, this.cgHash);
        _v_.after_cgHash(this, this.cgHash);
        super.universal_trv0(_v_);
        this.universal_trv0_aft(_v_);
    }
}

