/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.tools.daj;

import edu.neu.ccs.demeter.tools.daj.CommandLine;
import edu.neu.ccs.demeter.tools.daj.CommandLineException;
import edu.neu.ccs.demeter.tools.daj.CreateClassGraph;
import edu.neu.ccs.demeter.tools.daj.StreamFunnel;
import edu.neu.ccs.demeter.tools.daj.TraversalAspectList;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.aspectj.tools.ajc.Main;

public class DAJ {
    public static void main(String[] args) {
        if (args.length == 0) {
            CommandLine.printUsage();
            System.exit(-1);
        }
        System.exit(DAJ.compile(args));
    }

    public static int compile(String[] args) {
        CommandLine cmdLine;
        try {
            cmdLine = new CommandLine(args);
        }
        catch (CommandLineException e) {
            System.out.println("Error: " + e.getMessage());
            return -1;
        }
        return DAJ.compile(cmdLine);
    }

    static int compile(CommandLine cmdLine) {
        if (!DAJ.generateStubs(cmdLine)) {
            return -1;
        }
        if (cmdLine.isTraversalGenerationOption()) {
            return 0;
        }
        if (!DAJ.compileStubs(cmdLine)) {
            return -1;
        }
        if (cmdLine.isTraversalGenerationCompilationOption()) {
            return 0;
        }
        if (!DAJ.generateTraversals(cmdLine)) {
            return -1;
        }
        if (cmdLine.isTraversalCompilationOption()) {
            return 0;
        }
        if (!DAJ.compileTraversals(cmdLine)) {
            return -1;
        }
        return 0;
    }

    static boolean generateStubs(CommandLine cmdLine) {
        return DAJ.generateStubs(cmdLine.getTraversalFiles(), cmdLine.getTraversalDestinationOption());
    }

    public static boolean generateStubs(List traversalFiles) {
        return DAJ.generateStubs(traversalFiles, null);
    }

    public static boolean generateStubs(List traversalFiles, File destinationDirectory) {
        boolean returnVal = true;
        System.out.println("\n%I - Generating Stubs");
        Iterator it = traversalFiles.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            try {
                BufferedReader in = new BufferedReader(new FileReader(f));
                TraversalAspectList tal = TraversalAspectList.parse(in);
                returnVal = tal.generateStubs(destinationDirectory, DAJ.getRootName(f)) && returnVal;
            }
            catch (Exception e) {
                System.out.println(e);
                returnVal = false;
            }
        }
        return returnVal;
    }

    static boolean compileStubs(CommandLine cmdLine) {
        return DAJ.compileStubs(cmdLine.getAJC(), cmdLine.getTraversalFiles(), cmdLine.getTraversalDestinationOption(), cmdLine.getJavaFiles(), cmdLine.getAJCOptions(), cmdLine.getTempFileDirOption());
    }

    public static boolean compileStubs(String ajc, List traversalFiles, File stubsDirectory, List aspectFiles, List AJCOptions, File destinationDirectory) {
        ArrayList<Object> args = new ArrayList<Object>();
        if (destinationDirectory != null) {
            args.add("-d");
            args.add(destinationDirectory);
        }
        if (AJCOptions != null) {
            args.addAll(AJCOptions);
        }
        if (aspectFiles != null) {
            args.addAll(aspectFiles);
        }
        args.addAll(DAJ.getGeneratedFiles(traversalFiles, stubsDirectory));
        System.out.println("\n%I - traversal generation compilation\n" + (ajc == null ? "ajc" : ajc) + " " + DAJ.toStringWithSpaces(args));
        return DAJ.compileAspects(ajc, args);
    }

    static boolean generateTraversals(CommandLine cmdLine) {
        return DAJ.generateTraversals(cmdLine.getTraversalFiles(), cmdLine.getTempFileDirOption(), cmdLine.getGeneratePrintingAdviceOption(), cmdLine.getGenerationClassPathOption(), cmdLine.getTraversalDestinationOption());
    }

    public static boolean generateTraversals(List traversalFiles, File stubClassesDirectory, boolean generatePrintingAdvice, String classPath, File destinationDirectory) {
        if (stubClassesDirectory != null) {
            if (classPath == null) {
                classPath = System.getProperty("java.class.path");
            }
            classPath = stubClassesDirectory + File.pathSeparator + classPath;
        }
        ArrayList<Object> args = new ArrayList<Object>();
        if (generatePrintingAdvice) {
            args.add("-gpa");
        }
        if (destinationDirectory != null) {
            args.add("-d");
            args.add(destinationDirectory);
        }
        args.addAll(traversalFiles);
        return DAJ.generateTraversalsExec(classPath, args);
    }

    static boolean generateTraversals(String classPath, List args) {
        System.out.println("\n%I - traversal generation");
        if (classPath != null) {
            System.out.println("CLASSPATH = " + classPath);
            System.setProperty("java.class.path", classPath);
        }
        System.out.println("CreateClassGraph " + DAJ.toStringWithSpaces(args));
        CreateClassGraph.main(DAJ.toStringArray(args));
        return true;
    }

    static boolean generateTraversalsExec(String classPath, List args) {
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add("java");
        if (classPath != null) {
            cmd.add("-cp");
            cmd.add(classPath);
        }
        cmd.add("edu.neu.ccs.demeter.tools.daj.CreateClassGraph");
        cmd.addAll(args);
        System.out.println("\n%I - traversal generation\n" + DAJ.toStringWithSpaces(cmd));
        return DAJ.executeCommand(cmd);
    }

    static boolean compileTraversals(CommandLine cmdLine) {
        return DAJ.compileTraversals(cmdLine.getAJC(), cmdLine.getTraversalFiles(), cmdLine.getTraversalDestinationOption(), cmdLine.getJavaFiles(), cmdLine.getAJCOptions(), cmdLine.getTempFileDirOption());
    }

    public static boolean compileTraversals(String ajc, List traversalFiles, File traversalsDirectory, List aspectFiles, List AJCOptions, File destinationDirectory) {
        ArrayList<Object> args = new ArrayList<Object>();
        if (destinationDirectory != null) {
            args.add("-d");
            args.add(destinationDirectory);
        }
        if (AJCOptions != null) {
            args.addAll(AJCOptions);
        }
        if (aspectFiles != null) {
            args.addAll(aspectFiles);
        }
        args.addAll(DAJ.getGeneratedFiles(traversalFiles, traversalsDirectory));
        System.out.println("\n%I - traversal compilation\n" + (ajc == null ? "ajc" : ajc) + " " + DAJ.toStringWithSpaces(args));
        return DAJ.compileAspects(ajc, args);
    }

    public static boolean compileAspects(String ajc, List argList) {
        if (ajc == null) {
            String[] args = DAJ.toStringArray(argList);
            return new Main().compile(args) == 0;
        }
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(ajc);
        cmd.addAll(argList);
        return DAJ.executeCommand(cmd);
    }

    static boolean executeCommand(List cmdList) {
        return DAJ.executeCommand(DAJ.toStringArray(cmdList));
    }

    static boolean executeCommand(String[] cmd) {
        Process cmdProc = null;
        try {
            cmdProc = Runtime.getRuntime().exec(cmd);
            InputStream err = cmdProc.getErrorStream();
            InputStream in = cmdProc.getInputStream();
            StreamFunnel sf = new StreamFunnel(err, in, System.out);
            sf.run();
            cmdProc.waitFor();
            if (cmdProc.exitValue() != 0) {
                System.out.println("Error executing command: " + DAJ.toStringWithSpaces(cmd));
            }
            cmdProc.destroy();
        }
        catch (IllegalThreadStateException e) {
            e.printStackTrace(System.out);
            cmdProc.destroy();
            return false;
        }
        catch (IOException e) {
            System.out.print("%ERROR : ");
            System.out.println(e);
            System.out.println("\n%Information : \n You might need to specify -ajc ajc.bat or some other\nstring as the command to execute the AspectJ Compiler.\nDAJ is not smart enough to know that you're using windows\nand need to have ajc.bat instead of ajc.");
            return false;
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    static void forwardOutputStream(OutputStream out, InputStream in) throws IOException {
        int read = in.read();
        while (read > 0) {
            out.write((byte)read);
            read = in.read();
        }
    }

    public static List getGeneratedFiles(List traversalFiles, File destinationDirectory) {
        ArrayList<File> files = new ArrayList<File>();
        Iterator it = traversalFiles.iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            files.add(new File(destinationDirectory, DAJ.getRootName(f) + ".java"));
        }
        return files;
    }

    public static String getRootName(File f) {
        return DAJ.getRootName(f.getName());
    }

    public static String getRootName(String fname) {
        return fname.substring(0, fname.lastIndexOf("."));
    }

    static String[] toStringArray(List list) {
        String[] array = new String[list.size()];
        int i = 0;
        Iterator it = list.iterator();
        while (it.hasNext()) {
            array[i] = it.next().toString();
            ++i;
        }
        return array;
    }

    static String toStringWithSpaces(Object[] x) {
        return DAJ.toStringWithSpaces(Arrays.asList(x));
    }

    static String toStringWithSpaces(List x) {
        String s = "";
        Iterator it = x.iterator();
        while (it.hasNext()) {
            s = s + it.next();
            if (!it.hasNext()) continue;
            s = s + " ";
        }
        return s;
    }
}

