/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.tools.daj;

import edu.neu.ccs.demeter.tools.daj.CommandLineException;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class CommandLine {
    List javaFiles = new ArrayList();
    List trvFiles = new ArrayList();
    File dtrv;
    File dtmp;
    String gencp;
    String ajc;
    boolean gpa;
    boolean tgc;
    boolean tg;
    boolean tc;
    boolean ajtdebug;
    List ajcOptions = new ArrayList();

    static void printUsage() {
        String usage = "Usage: \njava edu.neu.ccs.demeter.tools.daj.DAJ [options] [java_files] [traversal_files]\n  java_files          The java files that need to be compiled.\n  traversal_files     The traversal files that need to be compiled.\n\nOptions\n  -gpa                Generate Printing Advice.\n  -dtrv <path>        The path to the generated traversal files\n  -ajc <executable>   Execute an aspect compiler via the shell instead of\n                      invoking the AspectJ compiler via the classpath.\n  -ajtdebug           Output debug info during traversal generation\n  -ajcopt [options]   The options for the AspectJ compiler.\n  -tg                 Stop after generating the stubs.\n  -tgc                Stop after compiling the stubs.\n  -tc                 Stop after generating the traversals.\n";
        System.out.println(usage);
    }

    CommandLine(String[] args) throws CommandLineException {
        int i = 0;
        while (i < args.length) {
            if (args[i].endsWith(".java")) {
                this.addJavaFile(new File(args[i]));
            } else if (args[i].endsWith(".trv")) {
                this.addTraversalFile(new File(args[i]));
            } else if (args[i].equals("-dtrv")) {
                if (++i >= args.length) {
                    CommandLine.fail("-dtrv option must be followed by a directory name.");
                }
                this.setTraversalDestinationOption(new File(args[i]));
            } else if (args[i].equals("-dtmp")) {
                if (++i >= args.length) {
                    CommandLine.fail("-dtmp option must be followed by a directory name.");
                }
                this.setTempFileDirOption(new File(args[i]));
            } else if (args[i].equals("-gencp")) {
                if (++i >= args.length) {
                    CommandLine.fail("-gencp option must be followed by a class path.");
                }
                this.setGenerationClassPathOption(args[i]);
            } else if (args[i].equals("-ajc")) {
                if (++i >= args.length) {
                    CommandLine.fail("-ajc option must be followed by the AspectJ compiler name.");
                }
                this.setAJC(args[i]);
            } else if (args[i].equals("-gpa")) {
                this.setGeneratePrintingAdviceOption();
            } else if (args[i].equals("-tgc")) {
                this.setTraversalGenerationCompilationOption();
            } else if (args[i].equals("-tg")) {
                this.setTraversalGenerationOption();
            } else if (args[i].equals("-tc")) {
                this.setTraversalCompilationOption();
            } else if (args[i].equals("-ajtdebug")) {
                this.setAspectJTraversalDebugOption();
            } else if (args[i].equals("-ajcopt")) {
                while (++i < args.length) {
                    this.addAJCOption(args[i]);
                }
            } else {
                CommandLine.fail("Command line argument unrecognized: " + args[i]);
            }
            ++i;
        }
        this.checkForErrors();
    }

    boolean isTraversalGenerationCompilationOption() {
        return this.tgc;
    }

    void setTraversalGenerationCompilationOption() {
        this.tgc = true;
    }

    boolean isTraversalGenerationOption() {
        return this.tg;
    }

    void setTraversalGenerationOption() {
        this.tg = true;
    }

    boolean isAspectJTraversalDebugOption() {
        return this.ajtdebug;
    }

    void setAspectJTraversalDebugOption() {
        this.ajtdebug = true;
    }

    boolean isTraversalCompilationOption() {
        return this.tc;
    }

    void setTraversalCompilationOption() {
        this.tc = true;
    }

    boolean getGeneratePrintingAdviceOption() {
        return this.gpa;
    }

    void setGeneratePrintingAdviceOption() {
        this.gpa = true;
    }

    String getGenerationClassPathOption() {
        return this.gencp;
    }

    void setGenerationClassPathOption(String x) {
        this.gencp = x;
    }

    File getTraversalDestinationOption() {
        return this.dtrv;
    }

    void setTraversalDestinationOption(File x) {
        this.dtrv = x;
    }

    File getTempFileDirOption() {
        return this.dtmp;
    }

    void setTempFileDirOption(File x) {
        this.dtmp = x;
    }

    List getAJCOptions() {
        return Collections.unmodifiableList(this.ajcOptions);
    }

    void addAJCOption(String x) {
        this.ajcOptions.add(x);
    }

    String getAJC() {
        return this.ajc;
    }

    void setAJC(String x) {
        this.ajc = x;
    }

    List getJavaFiles() {
        return Collections.unmodifiableList(this.javaFiles);
    }

    void addJavaFile(File x) {
        this.javaFiles.add(x);
    }

    List getTraversalFiles() {
        return Collections.unmodifiableList(this.trvFiles);
    }

    void addTraversalFile(File x) {
        this.trvFiles.add(x);
    }

    static void fail(String str) throws CommandLineException {
        throw new CommandLineException(str);
    }

    static boolean dirExists(String str) {
        return CommandLine.dirExists(new File(str));
    }

    static boolean dirExists(File f) {
        return f.exists() && f.isDirectory() && f.canWrite();
    }

    static boolean fileExists(String str) {
        return CommandLine.fileExists(new File(str));
    }

    static boolean fileExists(File f) {
        return f.exists() && f.isFile() && f.canRead();
    }

    void checkForErrors() throws CommandLineException {
        File tmpdir;
        File trvdir;
        List flist = this.getJavaFiles();
        if (flist.isEmpty()) {
            CommandLine.fail("You must specify at least one .java file to compile.");
        }
        if ((trvdir = this.getTraversalDestinationOption()) != null && !CommandLine.dirExists(trvdir)) {
            CommandLine.fail("The traversal generation directory specified by -dtrv\n" + trvdir + " does not exist.");
        }
        if ((tmpdir = this.getTempFileDirOption()) != null && !CommandLine.dirExists(tmpdir)) {
            CommandLine.fail("The tmp directory specified by the -dtmp\n" + tmpdir + " does not exist or not writable.");
        }
        if (!this.filesInCmdLineExist()) {
            CommandLine.fail("Files do not exist or are not readable.");
        }
    }

    boolean filesInCmdLineExist() {
        boolean returnVal = true;
        Iterator it = this.getTraversalFiles().iterator();
        while (it.hasNext()) {
            File f = (File)it.next();
            if (CommandLine.fileExists(f)) continue;
            System.out.println("Traversal file: " + f + " does not exist or is not readable.");
            returnVal = false;
        }
        Iterator it2 = this.getJavaFiles().iterator();
        while (it2.hasNext()) {
            File f = (File)it2.next();
            if (CommandLine.fileExists(f)) continue;
            System.out.println("Java file: " + f + " does not exist or is not readable.");
            returnVal = false;
        }
        return returnVal;
    }
}

