/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.tools.daj;

import edu.neu.ccs.demeter.aplib.EdgeI;
import edu.neu.ccs.demeter.aplib.NoSuchClassGraphNodeException;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.dj.ClassGraph;
import edu.neu.ccs.demeter.dj.TraversalGraph;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

class AspectJTraversal {
    TraversalGraph traversalGraph;
    String traversalName;
    String aspectName;
    StringBuffer aspectjTraversalCode;
    int copies;
    static boolean debug = false;
    static boolean debug2 = false;
    static boolean addPrintingAdvice = false;

    AspectJTraversal(String tn, TraversalGraph tg) throws NoSuchClassGraphNodeException {
        this.traversalGraph = tg;
        this.copies = this.getNumberOfCopies();
        this.traversalName = tn;
        this.aspectjTraversalCode = this.traversal2AspectJ(tn, tg);
        this.aspectName = tn;
    }

    AspectJTraversal(ClassGraph cg, String tn, String st) throws NoSuchClassGraphNodeException {
        TraversalGraph tg;
        this.traversalGraph = tg = new TraversalGraph(st, cg);
        this.copies = this.getNumberOfCopies();
        this.traversalName = tn;
        this.aspectjTraversalCode = this.traversal2AspectJ(tn, tg);
        this.aspectName = tn;
    }

    public String processTraversal(ClassGraph cg, String tn, String st) throws NoSuchClassGraphNodeException {
        TraversalGraph tg;
        this.traversalGraph = tg = new TraversalGraph(st, cg);
        this.traversalName = tn;
        this.appendDefaultTraversalWrapper(tn, AspectJTraversal.getSourceClassFromStrategy(st));
        StringBuffer newCode = this.traversal2AspectJ(tn, tg);
        this.aspectjTraversalCode.append(newCode);
        this.aspectName = tn;
        return newCode.toString();
    }

    AspectJTraversal() {
        this.traversalGraph = null;
        this.traversalName = null;
        this.aspectjTraversalCode = new StringBuffer();
    }

    public void appendDefaultTraversalWrapper(String tname, String className) {
        String addString = "  void " + className + "." + tname + "() {\n" + "  " + tname + "_copy0();\n" + "  }\n";
        this.appendToTraversalCode(addString);
    }

    public void appendToTraversalCode(String code) {
        this.aspectjTraversalCode.append(code);
    }

    public void setAspectName(String an) {
        this.aspectName = an;
    }

    public String getAspectName() {
        return this.aspectName;
    }

    public String getTraversalName() {
        return this.traversalName;
    }

    public static String getSourceClassFromStrategy(String strategyStr) {
        if (!strategyStr.startsWith("from")) {
            System.out.println("Strategy does not start with from: " + strategyStr);
            return "";
        }
        String startName = strategyStr.substring(5, strategyStr.indexOf(32, 5));
        if (startName.indexOf("*") > -1) {
            System.out.println("%Error : You can not have * in the source node of a \ntraversal in DAJ. DAJ can not know the classname to which it should create the stub.");
        }
        return startName;
    }

    public String toString() {
        String aspectHeader = new String("public aspect " + this.aspectName + " { \n");
        String aspectFooter = new String("} // " + this.aspectName + "\n");
        return aspectHeader + this.aspectjTraversalCode.toString() + aspectFooter;
    }

    public String toFile(File f) throws IOException {
        String outString = this.toString();
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(f)));
        pw.print(outString);
        pw.close();
        return outString;
    }

    protected static String cleanStrategyString(String travString) {
        StringBuffer newStr = new StringBuffer(100);
        int lastNext = 0;
        int nextLine = travString.indexOf(10);
        while (nextLine > -1) {
            newStr.append(travString.substring(lastNext, nextLine).trim());
            lastNext = nextLine + 1;
            nextLine = travString.indexOf(10, nextLine + 1);
        }
        newStr.append(travString.substring(lastNext, travString.length()).trim());
        return newStr.toString();
    }

    protected StringBuffer traversal2AspectJ(String tn, TraversalGraph tg) throws NoSuchClassGraphNodeException {
        StringBuffer returnBuffer = new StringBuffer();
        String travString = AspectJTraversal.cleanStrategyString(tg.getStrategy().toString());
        returnBuffer.append("  // traversal " + tn + " : " + travString + "\n");
        if (debug) {
            System.out.println("----------------------------------");
            System.out.println("Processing " + tn + ":" + travString);
            System.out.println(tg);
        }
        List nodeSets = tg.getNodeSets();
        if (debug) {
            System.out.println("nodesets: " + nodeSets);
        }
        Iterator iter = nodeSets.iterator();
        while (iter.hasNext()) {
            Object node = iter.next();
            TraversalGraph.NodeSet nodeset = (TraversalGraph.NodeSet)node;
            String nodeName = this.getNodeName(node);
            if (debug) {
                System.out.println("processing node: " + nodeName + " nodeset=" + node);
            }
            List incomingEdgeSets = this.getIncomingEdges(node);
            if (debug) {
                System.out.println("Incoming edges\n" + incomingEdgeSets);
            }
            int copyNum = 0;
            while (copyNum <= this.getNumberOfCopies()) {
                if (debug) {
                    System.out.println("  Processing copy#" + copyNum);
                }
                if (nodeset.hasIndex(copyNum) || this.isSourceToIntercopyEdge(nodeset, copyNum)) {
                    String targetCopyString;
                    int targetCopyNumber;
                    TraversalGraph.EdgeSet edgeset;
                    String srcCopyString = "_copy" + copyNum;
                    StringBuffer travBodyStr = new StringBuffer();
                    StringBuffer travBodyHeaderStr = new StringBuffer("  public void " + nodeName + "." + tn + srcCopyString + "(){\n");
                    StringBuffer travWrapperMethods = new StringBuffer();
                    boolean hasAddedCode = false;
                    TraversalGraph.EdgeSet inheritanceEdge = this.getInheritanceEdge(nodeset, copyNum);
                    TraversalGraph.EdgeSet alternationEdge = this.getAlternationEdge(nodeset, copyNum);
                    if (inheritanceEdge != null) {
                        edgeset = inheritanceEdge;
                        targetCopyNumber = this.getTargetCopyNumber(edgeset, copyNum);
                        targetCopyString = "_copy" + targetCopyNumber;
                        hasAddedCode = true;
                        travBodyStr.append("  super." + tn + targetCopyString + "();\n");
                        if (debug) {
                            System.out.println("  Processing: " + edgeset);
                        }
                    }
                    if (alternationEdge != null && !this.alternationEdgeEquivalentToInheritanceEdge(alternationEdge, inheritanceEdge, copyNum)) {
                        edgeset = alternationEdge;
                        targetCopyNumber = this.getTargetCopyNumber(edgeset, copyNum);
                        targetCopyString = "_copy" + targetCopyNumber;
                        hasAddedCode = true;
                        travBodyStr.append("  super." + tn + targetCopyString + "();\n");
                        if (debug) {
                            System.out.println("  Processing: " + edgeset);
                        }
                    }
                    List outgoingConstructionEdgeSets = this.getOutgoingConstructionEdges(nodeset, copyNum);
                    if (debug) {
                        System.out.println("  outgoing edges: \n  " + outgoingConstructionEdgeSets);
                    }
                    Iterator iterEdge = outgoingConstructionEdgeSets.iterator();
                    while (iterEdge.hasNext()) {
                        hasAddedCode = true;
                        TraversalGraph.EdgeSet edgeset2 = (TraversalGraph.EdgeSet)iterEdge.next();
                        EdgeI currentEdge = edgeset2.getEdge();
                        int targetCopyNumber2 = this.getTargetCopyNumber(edgeset2, copyNum);
                        String targetCopyString2 = "_copy" + targetCopyNumber2;
                        if (debug) {
                            System.out.println("  Processing edge: " + edgeset2);
                        }
                        travBodyStr.append("  if (" + currentEdge.getLabel() + " != null) " + tn + srcCopyString + "_crossing_" + currentEdge.getLabel() + "();\n");
                        travWrapperMethods.append("  public void " + nodeName + "." + tn + srcCopyString + "_crossing_" + currentEdge.getLabel() + "() { " + currentEdge.getLabel() + "." + tn + targetCopyString2 + "();}\n");
                    }
                    travBodyStr.append("  }\n");
                    if (hasAddedCode || this.hasIncomingConstructionEdge(nodeset, copyNum)) {
                        if (debug) {
                            System.out.println("  Adding generated code....");
                            System.out.println(travBodyHeaderStr.toString() + travBodyStr.toString() + travWrapperMethods.toString());
                        }
                        returnBuffer.append(travBodyHeaderStr);
                        returnBuffer.append(travBodyStr);
                        returnBuffer.append(travWrapperMethods);
                    } else if (debug) {
                        System.out.println("Skipping: " + nodeName);
                    }
                }
                ++copyNum;
            }
        }
        if (addPrintingAdvice) {
            String pointcutname = "pointcut_" + tn;
            returnBuffer.append("  pointcut " + pointcutname + "() : call(public void " + tn + "*());\n");
            returnBuffer.append("  before () : " + pointcutname + " () { \n");
            returnBuffer.append("  System.out.println(thisJoinPoint);\n");
            returnBuffer.append("  }\n");
        }
        if (debug) {
            System.out.println("+++++++++Generated Code+++++++++++++++++");
            System.out.println(returnBuffer);
            System.out.println("+++++++++Generated Code End+++++++++++++");
        }
        return returnBuffer;
    }

    protected List getOutgoingConstructionEdges(Object node, int copyNum) {
        List edgeList = this.traversalGraph.getEdgeSets();
        LinkedList<TraversalGraph.EdgeSet> newList = new LinkedList<TraversalGraph.EdgeSet>();
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            Object edgeNode = null;
            edgeNode = edge.getSource();
            if (debug2) {
                System.out.println("    outgoingEdgeSets: " + edgeset);
            }
            if (!this.isEdgeSetInCopy(edgeset, copyNum) || edgeNode.toString().compareTo(this.getNodeName(node)) != 0 || !edge.isConstructionEdge()) continue;
            newList.add(edgeset);
        }
        return newList;
    }

    protected TraversalGraph.EdgeSet getInheritanceEdge(Object node, int copyNum) {
        List edgeList = this.traversalGraph.getEdgeSets();
        TraversalGraph.EdgeSet returnEdge = null;
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            Object edgeNode = null;
            edgeNode = edge.getSource();
            if (debug2) {
                System.out.println("    get inheritance edge: " + edgeset);
            }
            if (!this.isEdgeSetInCopy(edgeset, copyNum) || edgeNode.toString().compareTo(this.getNodeName(node)) != 0 || !edge.isInheritanceEdge()) continue;
            if (returnEdge != null) {
                System.out.println("%Error: More than one inheritance edge for a copy detected.\n" + returnEdge + " and " + edgeset + " in same copy.");
            }
            returnEdge = edgeset;
        }
        return returnEdge;
    }

    protected TraversalGraph.EdgeSet getAlternationEdge(Object node, int copyNum) {
        List edgeList = this.traversalGraph.getEdgeSets();
        TraversalGraph.EdgeSet returnEdge = null;
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            Object edgeNode = null;
            edgeNode = edge.getTarget();
            if (debug2) {
                System.out.println("    get alternation edge: " + edgeset);
            }
            if (!this.isEdgeSetInCopy(edgeset, copyNum) || edgeNode.toString().compareTo(this.getNodeName(node)) != 0 || !edge.isAlternationEdge()) continue;
            if (returnEdge != null) {
                System.out.println("%Error: More than one inheritance edge for a copy detected.\n" + returnEdge + " and " + edgeset + " in same copy.");
            }
            returnEdge = edgeset;
        }
        return returnEdge;
    }

    protected boolean isEdgeSetInCopy(TraversalGraph.EdgeSet edgeset, int copyNum) {
        Integer num = new Integer(copyNum);
        List nums = this.getCopyNumberList(edgeset);
        return nums.indexOf(num) >= 0;
    }

    protected List getCopyNumberList(TraversalGraph.EdgeSet edgeset) {
        LinkedList<Integer> list = new LinkedList<Integer>();
        String edgeStr = edgeset.toString();
        if (debug2) {
            System.out.println("  getCopyNumberList: " + edgeset.toString());
        }
        int beginIndex = edgeStr.indexOf(123) + 1;
        int commaIndex = edgeStr.indexOf(44, beginIndex);
        int endIndex = edgeStr.indexOf(125, beginIndex);
        while (commaIndex > 0 && commaIndex < endIndex) {
            String intStr = edgeStr.substring(beginIndex, commaIndex).trim();
            if (debug2) {
                System.out.println("  int string = " + intStr);
            }
            list.add(new Integer(intStr));
            beginIndex = commaIndex + 1;
            commaIndex = edgeStr.indexOf(44, beginIndex);
        }
        if (beginIndex != endIndex) {
            list.add(new Integer(edgeStr.substring(beginIndex, endIndex).trim()));
        }
        Set indices = edgeset.getIntercopyIndices();
        Iterator iter = indices.iterator();
        while (iter.hasNext()) {
            int num = ((TraversalGraph.IndexPair)iter.next()).getSource();
            list.add(new Integer(num));
        }
        return list;
    }

    protected boolean alternationEdgeEquivalentToInheritanceEdge(TraversalGraph.EdgeSet alterEdge, TraversalGraph.EdgeSet inherEdge, int copyNum) {
        TraversalGraph.IndexPair inherPair;
        TraversalGraph.IndexPair alterPair;
        if (alterEdge == null || inherEdge == null) {
            return false;
        }
        return alterEdge.getEdge().getSource().toString().compareTo(inherEdge.getEdge().getTarget().toString()) == 0 && alterEdge.getEdge().getTarget().toString().compareTo(inherEdge.getEdge().getSource().toString()) == 0 && ((alterPair = this.getIndexPair(alterEdge, copyNum)) == (inherPair = this.getIndexPair(inherEdge, copyNum)) || alterPair != null && inherPair != null && alterPair.equals((Object)inherPair));
    }

    protected TraversalGraph.IndexPair getIndexPair(TraversalGraph.EdgeSet edgeset, int copyNum) {
        Set intercopySet = edgeset.getIntercopyIndices();
        if (intercopySet.size() == 0) {
            return null;
        }
        Iterator iter = intercopySet.iterator();
        while (iter.hasNext()) {
            TraversalGraph.IndexPair ip = (TraversalGraph.IndexPair)iter.next();
            if (ip.getSource() != copyNum) continue;
            return ip;
        }
        return null;
    }

    protected int getTargetCopyNumber(TraversalGraph.EdgeSet edgeset, int copyNum) {
        TraversalGraph.IndexPair ip = this.getIndexPair(edgeset, copyNum);
        if (ip == null) {
            return copyNum;
        }
        return ip.getTarget();
    }

    protected int getSourceCopyNumber(TraversalGraph.EdgeSet edgeset, int copyNum) {
        TraversalGraph.IndexPair ip = this.getIndexPair(edgeset, copyNum);
        if (ip == null) {
            return copyNum;
        }
        return ip.getSource();
    }

    protected boolean hasIncomingConstructionEdge(Object node, int copyNum) {
        List edgeList = this.traversalGraph.getEdgeSets();
        LinkedList newList = new LinkedList();
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            Object edgeNode = null;
            edgeNode = edge.getTarget();
            if (this.getTargetCopyNumber(edgeset, copyNum) != copyNum || edgeNode.toString().compareTo(this.getNodeName(node)) != 0 || !edge.isConstructionEdge()) continue;
            return true;
        }
        return false;
    }

    protected boolean isSourceToIntercopyEdge(TraversalGraph.NodeSet nodeset, int copyNum) {
        List edgeList = this.traversalGraph.getEdgeSets();
        Iterator edgeIter = edgeList.iterator();
        while (edgeIter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)edgeIter.next();
            Set pairSet = edgeset.getIntercopyIndices();
            Iterator pairIter = pairSet.iterator();
            while (pairIter.hasNext()) {
                int num = ((TraversalGraph.IndexPair)pairIter.next()).getSource();
                if (copyNum != num) continue;
                EdgeI edge = edgeset.getEdge();
                Object edgeNode = null;
                edgeNode = edge.isAlternationEdge() ? edge.getTarget() : edge.getSource();
                if (edgeNode.toString().compareTo(this.getNodeName(nodeset)) != 0) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean hasOneAndOnlyAlternationEdge(TraversalGraph.NodeSet node, int copyNum) {
        TraversalGraph.EdgeSet edgeset;
        EdgeI currentEdge;
        LinkedList allEdges = new LinkedList();
        allEdges.addAll(this.getProperOutgoingEdges(node, copyNum));
        if (debug2) {
            System.out.println("  hasOneAndOnlyAlternationEdge edges: " + allEdges);
        }
        return allEdges.size() == 1 && (currentEdge = (edgeset = (TraversalGraph.EdgeSet)allEdges.getFirst()).getEdge()).isAlternationEdge();
    }

    protected boolean hasInheritanceEdgeInSameCopy(TraversalGraph.EdgeSet leftEdgeset) {
        List inheritanceEdges = this.getInheritanceEdgeSets();
        Object srcEdgeNode = leftEdgeset.getEdge().getSource();
        Object targetEdgeNode = leftEdgeset.getEdge().getTarget();
        int copyNum = this.getSourceCopyNumber(leftEdgeset);
        Iterator iter = inheritanceEdges.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            Object thisSrcEdgeNode = edge.getSource();
            Object thisTargetEdgeNode = edge.getTarget();
            if (debug) {
                System.out.println(srcEdgeNode + " " + targetEdgeNode + "\n" + thisSrcEdgeNode + " " + thisTargetEdgeNode + "\n" + copyNum + "==" + this.getTargetCopyNumber(edgeset) + "\n");
            }
            if (srcEdgeNode.toString().compareTo(thisTargetEdgeNode.toString()) != 0 || targetEdgeNode.toString().compareTo(thisSrcEdgeNode.toString()) != 0 || copyNum != this.getTargetCopyNumber(edgeset)) continue;
            return true;
        }
        return false;
    }

    protected boolean hasInheritanceOrAlternationEdge(TraversalGraph.NodeSet nodeset, int copyNum) {
        List edgeList = this.traversalGraph.getEdgeSets();
        LinkedList newList = new LinkedList();
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            if (debug2) {
                System.out.println("  hasInheritanceOrAlternationEdge: " + edgeset);
            }
            Object edgeNode = null;
            int thisCopyNum = this.getSourceCopyNumber(edgeset);
            edgeNode = edgeset.getEdge().isAlternationEdge() ? edge.getTarget() : edge.getSource();
            if (debug2) {
                System.out.println("  hasInheritanceOrAlternationEdge: " + edgeNode);
            }
            if (thisCopyNum != copyNum || edgeNode.toString().compareTo(this.getNodeName(edgeNode)) != 0 || !edge.isInheritanceEdge() && !edge.isAlternationEdge()) continue;
            return true;
        }
        return false;
    }

    protected TraversalGraph.EdgeSet getInheritanceOrAlternationEdge(TraversalGraph.NodeSet nodeset, int copyNum) {
        List edgeList = this.traversalGraph.getEdgeSets();
        LinkedList newList = new LinkedList();
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            Object edgeNode = null;
            int thisCopyNum = this.getSourceCopyNumber(edgeset);
            edgeNode = edgeset.getEdge().isAlternationEdge() ? edge.getTarget() : edge.getSource();
            if (thisCopyNum != copyNum || edgeNode.toString().compareTo(this.getNodeName(edgeNode)) != 0 || !edge.isInheritanceEdge() && !edge.isAlternationEdge()) continue;
            return edgeset;
        }
        return null;
    }

    protected List getInheritanceEdgeSets() {
        List edgeList = this.traversalGraph.getEdgeSets();
        LinkedList<TraversalGraph.EdgeSet> newList = new LinkedList<TraversalGraph.EdgeSet>();
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            if (!edge.isInheritanceEdge()) continue;
            newList.add(edgeset);
        }
        return newList;
    }

    protected List getOutgoingEdges(Object node) {
        List edgeList = this.traversalGraph.getEdgeSets();
        LinkedList<TraversalGraph.EdgeSet> newList = new LinkedList<TraversalGraph.EdgeSet>();
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            Object edgeNode = null;
            edgeNode = edge.getSource();
            if (edgeNode.toString().compareTo(this.getNodeName(node)) != 0) continue;
            newList.add(edgeset);
        }
        return newList;
    }

    protected List getOutgoingEdges(Object node, int copyNum) {
        List edgeList = this.traversalGraph.getEdgeSets();
        LinkedList<TraversalGraph.EdgeSet> newList = new LinkedList<TraversalGraph.EdgeSet>();
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            Object edgeNode = null;
            edgeNode = edge.getSource();
            if (debug) {
                System.out.println("    outgoingEdgeSets: " + edgeset);
                System.out.println("    compare: " + this.getSourceCopyNumber(edgeset) + "==" + copyNum + "&&" + edgeNode + " == " + node);
            }
            if (this.getSourceCopyNumber(edgeset) != copyNum || edgeNode.toString().compareTo(this.getNodeName(node)) != 0) continue;
            newList.add(edgeset);
        }
        return newList;
    }

    protected List getProperOutgoingEdges(Object node, int copyNum) {
        List edgeList = this.traversalGraph.getEdgeSets();
        LinkedList<TraversalGraph.EdgeSet> newList = new LinkedList<TraversalGraph.EdgeSet>();
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            Object edgeNode = null;
            edgeNode = edgeset.getEdge().isAlternationEdge() ? edge.getTarget() : edge.getSource();
            if (debug2) {
                System.out.println("    outgoingEdgeSets: " + edgeset);
                System.out.println("    compare: " + this.getSourceCopyNumber(edgeset) + "==" + copyNum + "&&" + edgeNode + " == " + node);
            }
            if (this.getSourceCopyNumber(edgeset) != copyNum || edgeNode.toString().compareTo(this.getNodeName(node)) != 0) continue;
            newList.add(edgeset);
        }
        return newList;
    }

    protected List getIncomingEdges(Object node) {
        List edgeList = this.traversalGraph.getEdgeSets();
        LinkedList<TraversalGraph.EdgeSet> newList = new LinkedList<TraversalGraph.EdgeSet>();
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            EdgeI edge = edgeset.getEdge();
            Object edgeNode = null;
            edgeNode = edge.getTarget();
            if (edgeNode.toString().compareTo(this.getNodeName(node)) != 0) continue;
            newList.add(edgeset);
        }
        return newList;
    }

    protected String getNodeName(Object node) {
        String nodeNameRaw = new String(node.toString());
        String nodeName = nodeNameRaw.indexOf(58) < 0 ? nodeNameRaw : nodeNameRaw.substring(0, nodeNameRaw.indexOf(58));
        return nodeName;
    }

    public int getNumberOfCopies() {
        List edgeList = this.traversalGraph.getEdgeSets();
        int returnVal = 0;
        Iterator iter = edgeList.iterator();
        while (iter.hasNext()) {
            TraversalGraph.EdgeSet edgeset = (TraversalGraph.EdgeSet)iter.next();
            Set intercopy = edgeset.getIntercopyIndices();
            Iterator iter2 = intercopy.iterator();
            while (iter2.hasNext()) {
                TraversalGraph.IndexPair ip = (TraversalGraph.IndexPair)iter2.next();
                if (ip.getTarget() <= returnVal) continue;
                returnVal = ip.getTarget();
            }
        }
        if (debug) {
            System.out.println("  total copies : " + returnVal);
        }
        return returnVal;
    }

    protected int getCopyNumber(TraversalGraph.EdgeSet edgeset) {
        String edgeStr = edgeset.toString();
        if (debug) {
            System.out.println("  getCopyNumber: " + edgeset.toString());
        }
        int copyNum = 0;
        copyNum = edgeset.getIntercopyIndices().size() == 0 ? Integer.parseInt(edgeStr.substring(edgeStr.indexOf(123) + 1, edgeStr.indexOf(125))) : ((TraversalGraph.IndexPair)edgeset.getIntercopyIndices().iterator().next()).getSource();
        return copyNum;
    }

    protected int getCopyNumber(EdgeI edge) {
        TraversalGraph.EdgeSet edgeset = this.traversalGraph.getEdgeSet(edge);
        int returnVal = this.getCopyNumber(edgeset);
        if (debug) {
            System.out.println("  getCopyNumber: " + returnVal + " for: " + edgeset);
        }
        return returnVal;
    }

    protected int getTargetCopyNumber(TraversalGraph.EdgeSet edgeset) {
        Set indexpair = edgeset.getIntercopyIndices();
        if (indexpair.size() == 0) {
            int num = this.getCopyNumber(edgeset.getEdge());
            return num;
        }
        if (indexpair.size() > 1) {
            System.out.println("%Error: There are more than one intercopy indicies.\nPlease notify the developer of this expected error.");
        }
        int returnVal = 0;
        Iterator iter = indexpair.iterator();
        while (iter.hasNext()) {
            TraversalGraph.IndexPair ip = (TraversalGraph.IndexPair)iter.next();
            returnVal = ip.getTarget();
        }
        return returnVal;
    }

    protected int getSourceCopyNumber(TraversalGraph.EdgeSet edgeset) {
        Set indexpair = edgeset.getIntercopyIndices();
        if (indexpair.size() == 0) {
            int num = this.getCopyNumber(edgeset.getEdge());
            return num;
        }
        if (indexpair.size() > 1) {
            System.out.println("%Error: There are more than one intercopy indicies.\nPlease notify the developer of this error.");
        }
        int returnVal = 0;
        Iterator iter = indexpair.iterator();
        while (iter.hasNext()) {
            TraversalGraph.IndexPair ip = (TraversalGraph.IndexPair)iter.next();
            returnVal = ip.getSource();
        }
        return returnVal;
    }

    protected static String getTargetNodeName(TraversalGraph.EdgeSet edgeset) {
        if (debug) {
            System.out.println("getTargetNodeName : " + edgeset.getEdge().getTarget());
        }
        return edgeset.getEdge().getTarget().toString();
    }
}

