/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.dj;

import edu.neu.ccs.demeter.dj.Visitor;
import edu.neu.ccs.demeter.dj.VisitorMethodException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public abstract class Visitor {
    private static Map methods = new HashMap();

    public void start() {
    }

    public void finish() {
    }

    public Object getReturnValue() {
        return null;
    }

    public void before(Object obj, Class cl) {
        this.invokeMethod("before", obj, cl);
    }

    public void after(Object obj, Class cl) {
        this.invokeMethod("after", obj, cl);
    }

    public void invokeMethod(String name, Object obj, Class cl) {
        try {
            Method meth = this.getMethod(name, cl);
            if (meth != null) {
                ((AccessibleObject)meth).setAccessible(true);
                meth.invoke((Object)this, obj);
            }
        }
        catch (SecurityException e) {
            return;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("\n" + e);
        }
        catch (InvocationTargetException e) {
            throw new VisitorMethodException(e.getTargetException());
        }
    }

    public Method getMethod(String name, Class hostClass) {
        Class<?> visitorClass = this.getClass();
        class Signature {
            private final /* synthetic */ Class val$visitorClass;
            private final /* synthetic */ String val$name;
            private final /* synthetic */ Class val$hostClass;
            private final /* synthetic */ Visitor this$0;

            Signature(Visitor this$0, Class val$visitorClass, String val$name, Class val$hostClass) {
                this.this$0 = this$0;
                this.val$visitorClass = val$visitorClass;
                this.val$name = val$name;
                this.val$hostClass = val$hostClass;
            }

            public boolean equals(Object x) {
                if (!(x instanceof Signature)) {
                    return false;
                }
                Signature s = (Signature)x;
                return s.getVisitorClass().equals(this.getVisitorClass()) && s.getName().equals(this.getName()) && s.getHostClass().equals(this.getHostClass());
            }

            public int hashCode() {
                return this.getVisitorClass().hashCode() + this.getName().hashCode() + this.getHostClass().hashCode();
            }

            Class getVisitorClass() {
                return this.val$visitorClass;
            }

            String getName() {
                return this.val$name;
            }

            Class getHostClass() {
                return this.val$hostClass;
            }

            public String toString() {
                return this.getVisitorClass().getName() + "." + this.getName() + "(" + this.getHostClass().getName() + ")";
            }
        }
        Signature key = new Signature(this, visitorClass, name, hostClass);
        if (methods.containsKey(key)) {
            return (Method)methods.get(key);
        }
        Method method = this.getUnmemoizedMethod(name, hostClass);
        methods.put(key, method);
        return method;
    }

    protected Method getUnmemoizedMethod(String name, Class cl) {
        Class[] params = new Class[]{cl};
        Class<?> vcl = this.getClass();
        while (vcl != null) {
            try {
                return vcl.getDeclaredMethod(name, params);
            }
            catch (NoSuchMethodException e) {
                vcl = vcl.getSuperclass();
            }
        }
        return null;
    }
}

