/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.dj;

import edu.neu.ccs.demeter.aplib.EdgeI;
import edu.neu.ccs.demeter.aplib.NoSuchClassGraphNodeException;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.dj.ClassGraph;
import edu.neu.ccs.demeter.dj.Collection;
import edu.neu.ccs.demeter.dj.FetchException;
import edu.neu.ccs.demeter.dj.IncompatibleClassGraphsException;
import edu.neu.ccs.demeter.dj.ObjectGraph;
import edu.neu.ccs.demeter.dj.Strategy;
import edu.neu.ccs.demeter.dj.TraversalGraph;
import edu.neu.ccs.demeter.dj.TraversalGraphException;
import edu.neu.ccs.demeter.dj.TraversalSourceException;
import edu.neu.ccs.demeter.dj.Visitor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class ObjectGraphSlice {
    protected TraversalGraph tg;
    protected ObjectGraph og;
    protected Object root;
    protected TraversalGraph.NodeSet startSet;
    public boolean debug;
    protected List targetClasses;
    protected boolean computedTargetClasses;
    static Map members = new HashMap();

    public ObjectGraphSlice(ObjectGraph o, TraversalGraph t) {
        if (o.getClassGraph() != t.getClassGraph()) {
            throw new IncompatibleClassGraphsException(o, t);
        }
        this.tg = t;
        this.og = o;
        this.root = o.getRoot();
        this.startSet = this.getStartSet(this.root.getClass());
        if (this.startSet == null) {
            throw new TraversalSourceException(this.root, this.tg);
        }
    }

    public ObjectGraphSlice(Object o, TraversalGraph t) {
        this(new ObjectGraph(o, (ClassGraph)t.getClassGraph()), t);
    }

    public ObjectGraphSlice(ObjectGraph o, Strategy s) throws TraversalGraphException {
        this(o, new TraversalGraph(s, o.getClassGraph()));
    }

    public ObjectGraphSlice(ObjectGraph o, String s) throws TraversalGraphException {
        this(o, new Strategy(s));
    }

    public TraversalGraph getTraversalGraph() {
        return this.tg;
    }

    public ObjectGraph getObjectGraph() {
        return this.og;
    }

    public Object getRoot() {
        return this.root;
    }

    public ClassGraph getClassGraph() {
        return (ClassGraph)this.tg.getClassGraph();
    }

    public Strategy getStrategy() {
        return (Strategy)this.tg.getStrategy();
    }

    public boolean equals(Object ogs) {
        if (ogs == this) {
            return true;
        }
        if (!(ogs instanceof ObjectGraphSlice)) {
            return false;
        }
        return ((ObjectGraphSlice)ogs).tg.equals(this.tg) && ((ObjectGraphSlice)ogs).root.equals(this.root);
    }

    public Object traverse(Visitor v) {
        return this.traverse(new Visitor[]{v}, true);
    }

    public Object traverse(Visitor v, boolean forward) {
        return this.traverse(new Visitor[]{v}, forward);
    }

    public Object traverse(Visitor[] v) {
        return this.traverse(v, true);
    }

    public Object traverse(Visitor[] v, boolean forward) {
        int i = 0;
        while (i < v.length) {
            v[i].start();
            ++i;
        }
        Object ret = new VisitorTraverser(v, forward).traverse(this.root, this.startSet);
        int i2 = v.length - 1;
        while (i2 >= 0) {
            v[i2].finish();
            --i2;
        }
        return ret;
    }

    public Object fetch() throws FetchException {
        List cs = this.getTargetClasses();
        if (cs == null) {
            throw new FetchException("Cannot fetch wildcard target.");
        }
        if (cs.isEmpty()) {
            throw new FetchException("Cannot fetch without a target.");
        }
        if (cs.size() > 1) {
            throw new FetchException("Cannot fetch multiple targets.");
        }
        return new Fetcher().traverse(this.root, this.startSet);
    }

    public List gather() {
        return this.gather(true);
    }

    public List gather(boolean forward) {
        return (List)new Gatherer(forward).traverse(this.root, this.startSet);
    }

    public List asList() {
        return this.asList(true);
    }

    public List asList(boolean forward) {
        return new APCollection(forward);
    }

    protected List getTargetClasses() {
        if (!this.computedTargetClasses) {
            this.computedTargetClasses = true;
            Strategy s = this.getStrategy();
            java.util.Collection targetNodes = s.getTargets();
            this.targetClasses = new ArrayList();
            Iterator it = targetNodes.iterator();
            while (it.hasNext()) {
                java.util.Collection targetNames = s.getNames(it.next());
                if (targetNames == null) {
                    this.targetClasses = null;
                    break;
                }
                Iterator it2 = targetNames.iterator();
                while (it2.hasNext()) {
                    this.targetClasses.add(this.getClassNamed((String)it2.next()));
                }
            }
        }
        return this.targetClasses;
    }

    boolean isTargetClass(Class cl) {
        List cs = this.getTargetClasses();
        return cs == null || cs.contains(cl);
    }

    TraversalGraph.NodeSet getStartSet(Class cl) {
        TraversalGraph.NodeSet startSet = null;
        do {
            try {
                Object v = this.getClassGraph().getNode(cl.getName());
                startSet = this.tg.getStartSet(v);
                if (startSet == null) continue;
                break;
            }
            catch (NoSuchClassGraphNodeException noSuchClassGraphNodeException) {
                // empty catch block
            }
        } while ((cl = cl.getSuperclass()) != null);
        return startSet;
    }

    Member getMember(Class cl, EdgeI edge) {
        AccessibleObject member = null;
        if (members.containsKey(edge)) {
            return (Member)members.get(edge);
        }
        ClassGraph cg = this.getClassGraph();
        if (edge.isConstructionEdge()) {
            String name = ClassGraph.memberName(edge);
            if (cg.isDerivedEdge(edge)) {
                try {
                    member = cl.getDeclaredMethod(name, null);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException("\n" + name + ": " + e);
                }
            }
            try {
                member = cl.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException("\n" + name + ": " + e);
            }
        }
        members.put(edge, member);
        return member;
    }

    Class getTargetClass(Class src, EdgeI edge) {
        if (edge.isAlternationEdge()) {
            throw new RuntimeException("Can't get subclass");
        }
        if (edge.isInheritanceEdge()) {
            return src.getSuperclass();
        }
        if (edge.isConstructionEdge()) {
            return ObjectGraphSlice.getTargetClass(this.getMember(src, edge));
        }
        return null;
    }

    static Class getTargetClass(Member member) {
        if (member instanceof Field) {
            return ((Field)member).getType();
        }
        return ((Method)member).getReturnType();
    }

    Object getTargetObject(Object source, Class cl, EdgeI edge) {
        if (edge.isAlternationEdge() || edge.isInheritanceEdge()) {
            return source;
        }
        if (edge.isConstructionEdge()) {
            return this.getTargetObject(source, this.getMember(cl, edge));
        }
        return null;
    }

    Object getTargetObject(Object source, Member member) {
        try {
            ((AccessibleObject)((Object)member)).setAccessible(true);
            if (member instanceof Field) {
                return ((Field)member).get(source);
            }
            return ((Method)member).invoke(source, null);
        }
        catch (SecurityException e) {
            if (this.debug) {
                System.out.println("Couldn't set accessible " + member);
            }
        }
        catch (IllegalAccessException e) {
            if (this.debug) {
                System.out.println("Couldn't access " + member);
            }
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("\n" + e.getTargetException());
        }
        return null;
    }

    void setTargetObject(Object source, Class cl, EdgeI edge, Object target) {
        if (!edge.isConstructionEdge()) {
            throw new RuntimeException("Not a construction edge: " + edge);
        }
        this.setTargetObject(source, this.getMember(cl, edge), target);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setTargetObject(Object source, Member member, Object target) {
        if (!(member instanceof Field)) throw new RuntimeException("Derived edge: " + member);
        try {
            ((AccessibleObject)((Object)member)).setAccessible(true);
            ((Field)member).set(source, target);
            return;
        }
        catch (SecurityException e) {
            if (!this.debug) return;
            System.out.println("Couldn't set accessible " + member);
            return;
        }
        catch (IllegalAccessException e) {
            if (!this.debug) return;
            System.out.println("Couldn't access " + member);
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("\n" + member + ": " + e);
        }
    }

    Class getTokensClass(TraversalGraph.NodeSet nodes) {
        return this.getNodeClass(nodes.getNode());
    }

    Class getClassNamed(String name) {
        return this.getClassGraph().getClassNamed(name);
    }

    Class getNodeClass(Object node) {
        return this.getClassGraph().getNodeClass(node);
    }

    boolean isRepetitionEdge(EdgeI edge) {
        this.getClassGraph();
        return ClassGraph.isRepetitionEdge(edge);
    }

    boolean isCollection(Object obj) {
        this.getClassGraph();
        return ClassGraph.isCollectionClass(obj.getClass());
    }

    static Iterator getIterator(Object obj) {
        if (obj instanceof java.util.Collection) {
            return ((java.util.Collection)obj).iterator();
        }
        final Enumeration e = ((Collection)obj).elements();
        return new Iterator(){

            public boolean hasNext() {
                return e.hasMoreElements();
            }

            public Object next() {
                return e.nextElement();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    static ListIterator getListIterator(Object obj) {
        if (obj instanceof List) {
            return ((List)obj).listIterator();
        }
        final Iterator it = ObjectGraphSlice.getIterator(obj);
        return new ListIterator(){

            public boolean hasNext() {
                return it.hasNext();
            }

            public Object next() {
                return it.next();
            }

            public void remove() {
                it.remove();
            }

            UnsupportedOperationException bomb() {
                return new UnsupportedOperationException();
            }

            public boolean hasPrevious() {
                throw this.bomb();
            }

            public Object previous() {
                throw this.bomb();
            }

            public void add(Object o) {
                throw this.bomb();
            }

            public void set(Object o) {
                throw this.bomb();
            }

            public int nextIndex() {
                throw this.bomb();
            }

            public int previousIndex() {
                throw this.bomb();
            }
        };
    }

    class APCollection
    extends AbstractSequentialList {
        boolean forward = true;

        APCollection(boolean f) {
            this.forward = f;
        }

        ObjectGraphSlice getOGS() {
            return ObjectGraphSlice.this;
        }

        List gather() {
            return ObjectGraphSlice.this.gather(this.forward);
        }

        public int size() {
            return this.gather().size();
        }

        public int maxSize() {
            return this.size();
        }

        public boolean contains(Object obj) {
            return this.gather().contains(obj);
        }

        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        public Object[] toArray() {
            return this.gather().toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.gather().toArray(a);
        }

        public String toString() {
            return this.gather().toString();
        }

        public int hashCode() {
            return this.gather().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof List)) {
                return false;
            }
            if (obj instanceof APCollection && ((APCollection)obj).getOGS().equals(this.getOGS())) {
                return true;
            }
            return super.equals(obj);
        }

        public ListIterator listIterator() {
            return new Itr();
        }

        public ListIterator listIterator(int n) {
            ListIterator i = this.listIterator();
            while (n-- > 0) {
                i.next();
            }
            return i;
        }

        class Itr2
        implements ListIterator {
            Frame next;
            Frame prev;
            int index;
            boolean lastMoveWasForward;

            Itr2() {
                this.moveToBegin();
            }

            void moveToBegin() {
                this.next = new Frame(true, ((APCollection)APCollection.this).ObjectGraphSlice.this.root, ((APCollection)APCollection.this).ObjectGraphSlice.this.startSet, null, null);
                this.move(true);
                this.index = 0;
            }

            ObjectGraphSlice getOGS() {
                return ObjectGraphSlice.this;
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public boolean hasPrevious() {
                return this.prev != null;
            }

            public Object next() {
                if (((APCollection)APCollection.this).ObjectGraphSlice.this.debug) {
                    System.out.println("** next() **");
                }
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.prev = (Frame)this.next.clone();
                this.next = this.move(true);
                return this.prev.obj;
            }

            public Object previous() {
                if (((APCollection)APCollection.this).ObjectGraphSlice.this.debug) {
                    System.out.println("** previous() **");
                }
                if (!this.hasPrevious()) {
                    throw new NoSuchElementException();
                }
                this.next = (Frame)this.prev.clone();
                this.prev = this.move(false);
                return this.next.obj;
            }

            public int nextIndex() {
                return this.index;
            }

            public int previousIndex() {
                return this.index - 1;
            }

            UnsupportedOperationException bomb() {
                return new UnsupportedOperationException();
            }

            public void add(Object o) {
                throw this.bomb();
            }

            public void remove() {
                throw this.bomb();
            }

            public boolean equals(Object iterator) {
                if (!(iterator instanceof Itr2)) {
                    return false;
                }
                Itr2 tgi = (Itr2)iterator;
                if (!tgi.getOGS().equals(this.getOGS())) {
                    return false;
                }
                if (!(tgi.next == null && this.next == null || tgi.next != null && this.next != null)) {
                    return false;
                }
                return tgi.next.equals(this.next);
            }

            public void set(Object obj) {
                Frame frame;
                if (((APCollection)APCollection.this).ObjectGraphSlice.this.debug) {
                    System.out.println("** set(" + obj + ") **");
                }
                Frame frame2 = frame = this.lastMoveWasForward ? this.prev : this.next;
                if (frame == null) {
                    throw new IllegalStateException();
                }
                Frame p = frame.parent;
                if (p == null) {
                    throw new UnsupportedOperationException("Cannot replace the root of the object graph.");
                }
                p.it.set(obj);
                frame.obj = obj;
            }

            Frame move(boolean forward) {
                this.lastMoveWasForward = forward;
                this.index = forward ? ++this.index : --this.index;
                Frame frame = forward ? this.next : this.prev;
                boolean moved = false;
                do {
                    Object succ;
                    if (((APCollection)APCollection.this).ObjectGraphSlice.this.debug) {
                        System.out.println(frame);
                    }
                    if (frame.atBegin) {
                        if (moved && ObjectGraphSlice.this.isTargetClass(ObjectGraphSlice.this.getTokensClass(frame.tokens))) {
                            return frame;
                        }
                        if (forward) {
                            frame.atBegin = false;
                            moved = true;
                            continue;
                        }
                        frame = frame.parent;
                        moved = false;
                        continue;
                    }
                    Frame.SuccessorIterator it = frame.it;
                    if (it == null) {
                        it = frame.setupSuccessorIterator(forward);
                    }
                    if (!forward) {
                        if (!it.hasPrevious()) {
                            frame.atBegin = true;
                            moved = true;
                            continue;
                        }
                        succ = it.previous();
                        moved = true;
                    } else {
                        if (!it.hasNext()) {
                            frame = frame.parent;
                            moved = false;
                            continue;
                        }
                        succ = it.next();
                        moved = true;
                    }
                    if (succ == null) continue;
                    frame = new Frame(forward, succ, it.getTokens(), null, frame);
                } while (frame != null);
                return frame;
            }

            class Frame
            implements Cloneable {
                boolean atBegin;
                Object obj;
                TraversalGraph.NodeSet tokens;
                SuccessorIterator it;
                Frame parent;

                Frame(boolean a, Object o, TraversalGraph.NodeSet n, SuccessorIterator t, Frame p) {
                    this.atBegin = a;
                    this.obj = o;
                    this.tokens = n;
                    this.it = t;
                    this.parent = p;
                }

                public Object clone() {
                    return new Frame(this.atBegin, this.obj, this.tokens, (SuccessorIterator)(this.it == null ? null : this.it.clone()), (Frame)(this.parent == null ? null : this.parent.clone()));
                }

                public boolean equals(Object o) {
                    if (!(o instanceof Frame)) {
                        return false;
                    }
                    Frame frame = (Frame)o;
                    return this.atBegin == frame.atBegin && this.obj == frame.obj && this.tokens.equals(frame.tokens) && (this.it == null && frame.it == null || this.it.equals(frame.it)) && (this.parent == null && frame.parent == null || this.parent.equals(frame.parent));
                }

                public String toString() {
                    return "<" + (this.atBegin ? "begin " : "") + this.obj + " " + this.tokens + " (" + this.it + ")>\n" + (this.parent == null ? "" : this.parent.toString());
                }

                SuccessorIterator setupSuccessorIterator(boolean atBegin) {
                    this.it = this.obj.getClass().isArray() ? new ArrayIterator(atBegin) : new EdgeIterator(atBegin);
                    return this.it;
                }

                class ListRepetitionIterator
                extends RepetitionIterator {
                    ListRepetitionIterator(boolean atBegin) {
                        List l = (List)Frame.this.obj;
                        this.iter = l.listIterator(atBegin ? 0 : (this.i = l.size() - 1));
                    }

                    boolean hasPrevious() {
                        return ((ListIterator)this.iter).hasPrevious();
                    }

                    Object previous() {
                        return ((ListIterator)this.iter).previous();
                    }

                    void set(Object o) {
                        ((ListIterator)this.iter).set(o);
                    }

                    protected ListRepetitionIterator() {
                    }

                    protected RepetitionIterator make() {
                        return new ListRepetitionIterator();
                    }

                    protected Iterator cloneIterator() {
                        if (this.iter instanceof Cloneable) {
                            return super.cloneIterator();
                        }
                        return ((List)Frame.this.obj).listIterator(this.i);
                    }

                    public boolean equals(Object o) {
                        return o instanceof ListRepetitionIterator && super.equals(o);
                    }
                }

                class RepetitionIterator {
                    Iterator iter;
                    int i;

                    RepetitionIterator(boolean atBegin) {
                        if (!atBegin) {
                            throw new UnsupportedOperationException("Don't know how to iterate backward over " + ObjectGraphSlice.this.getTokensClass(Frame.this.tokens));
                        }
                        this.iter = ObjectGraphSlice.getIterator(Frame.this.obj);
                    }

                    boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    boolean hasPrevious() {
                        return this.i > 0;
                    }

                    Object next() {
                        ++this.i;
                        return this.iter.next();
                    }

                    Object previous() {
                        throw new UnsupportedOperationException("Don't know how to iterate backward over " + ObjectGraphSlice.this.getTokensClass(Frame.this.tokens));
                    }

                    void set(Object o) {
                        throw new UnsupportedOperationException("Don't know how to modify " + this.iter.getClass());
                    }

                    protected RepetitionIterator() {
                    }

                    protected RepetitionIterator make() {
                        return new RepetitionIterator();
                    }

                    public Object clone() {
                        RepetitionIterator o = this.make();
                        o.iter = this.cloneIterator();
                        o.i = this.i;
                        return o;
                    }

                    protected Iterator cloneIterator() {
                        Iterator copy_of_iter;
                        if (this.iter instanceof Cloneable) {
                            try {
                                copy_of_iter = (Iterator)this.iter.getClass().getMethod("clone", null).invoke((Object)this.iter, null);
                            }
                            catch (Exception e) {
                                throw new RuntimeException("\n" + e);
                            }
                        } else {
                            copy_of_iter = ObjectGraphSlice.getIterator(Frame.this.obj);
                            int j = 0;
                            while (j <= this.i) {
                                copy_of_iter.next();
                                ++j;
                            }
                        }
                        return copy_of_iter;
                    }

                    public boolean equals(Object o) {
                        if (!(o instanceof RepetitionIterator)) {
                            return false;
                        }
                        RepetitionIterator c = (RepetitionIterator)o;
                        return c.i == this.i;
                    }

                    public String toString() {
                        return this.i + "";
                    }
                }

                class EdgeIterator
                extends SuccessorIterator {
                    ListIterator edgeIt;
                    TraversalGraph.EdgeSet edgeSet;
                    RepetitionIterator it;

                    EdgeIterator(boolean atBegin) {
                        List edgeSets = Frame.this.tokens.getOutgoingEdgeSets();
                        this.edgeIt = atBegin ? edgeSets.listIterator() : edgeSets.listIterator(edgeSets.size());
                    }

                    boolean hasNext() {
                        return this.it != null && this.it.hasNext() || this.edgeIt.hasNext();
                    }

                    boolean hasPrevious() {
                        return this.it != null && this.it.hasPrevious() || this.edgeIt.hasPrevious();
                    }

                    Object next() {
                        return this.move(true);
                    }

                    Object previous() {
                        return this.move(false);
                    }

                    Object move(boolean forward) {
                        if (this.it != null) {
                            if (forward ? this.it.hasNext() : this.it.hasPrevious()) {
                                return forward ? this.it.next() : this.it.previous();
                            }
                            this.it = null;
                        }
                        this.edgeSet = (TraversalGraph.EdgeSet)(forward ? this.edgeIt.next() : this.edgeIt.previous());
                        EdgeI edge = this.edgeSet.getEdge();
                        if (edge.isConstructionEdge()) {
                            if (ObjectGraphSlice.this.isRepetitionEdge(edge)) {
                                this.it = Frame.this.obj instanceof List ? new ListRepetitionIterator(forward) : new RepetitionIterator(forward);
                            } else {
                                Member member = ObjectGraphSlice.this.getMember(ObjectGraphSlice.this.getTokensClass(Frame.this.tokens), edge);
                                Class type = ObjectGraphSlice.getTargetClass(member);
                                if (!type.isPrimitive()) {
                                    return ObjectGraphSlice.this.getTargetObject(Frame.this.obj, member);
                                }
                            }
                        } else if (edge.isAlternationEdge()) {
                            if (forward && ObjectGraphSlice.this.getTokensClass(Frame.this.tokens).isInstance(Frame.this.obj)) {
                                if (((APCollection)((Itr2)((Frame)Frame.this).Itr2.this).APCollection.this).ObjectGraphSlice.this.debug) {
                                    System.out.println(Frame.this.obj + " isa " + ObjectGraphSlice.this.getTokensClass(Frame.this.tokens));
                                }
                                return Frame.this.obj;
                            }
                        } else if (edge.isInheritanceEdge()) {
                            return Frame.this.obj;
                        }
                        return null;
                    }

                    TraversalGraph.NodeSet getTokens() {
                        return this.edgeSet.getTargetNodeSet();
                    }

                    void set(Object o) {
                        if (this.it != null) {
                            this.it.set(o);
                        }
                        EdgeI edge = this.edgeSet.getEdge();
                        if (ObjectGraphSlice.this.getNodeClass(edge.getTarget()).isAssignableFrom(o.getClass())) {
                            throw new UnsupportedOperationException("Incompatible object.");
                        }
                        ObjectGraphSlice.this.setTargetObject(Frame.this.obj, ObjectGraphSlice.this.getTokensClass(Frame.this.tokens), edge, o);
                    }

                    protected EdgeIterator() {
                    }

                    public Object clone() {
                        EdgeIterator ret = new EdgeIterator();
                        ret.edgeIt = this.cloneListIterator();
                        ret.edgeSet = this.edgeSet;
                        if (this.it != null) {
                            ret.it = (RepetitionIterator)this.it.clone();
                        }
                        return ret;
                    }

                    protected ListIterator cloneListIterator() {
                        ListIterator ret = null;
                        if (this.edgeIt instanceof Cloneable) {
                            try {
                                ret = (ListIterator)this.edgeIt.getClass().getMethod("clone", null).invoke((Object)this.edgeIt, null);
                            }
                            catch (Exception e) {
                                throw new RuntimeException("\n" + e);
                            }
                        } else {
                            List edgeSets = Frame.this.tokens.getOutgoingEdgeSets();
                            ret = edgeSets.listIterator(this.edgeIt.nextIndex());
                        }
                        return ret;
                    }

                    public boolean equals(Object o) {
                        if (!(o instanceof EdgeIterator)) {
                            return false;
                        }
                        EdgeIterator eit = (EdgeIterator)o;
                        return eit.edgeIt.equals(this.edgeIt) && eit.edgeSet.equals(this.edgeSet) && (eit.it == null && this.it == null || eit.it != null && this.it != null && eit.it.equals(this.it));
                    }

                    public String toString() {
                        return this.edgeSet + ": " + String.valueOf(this.it);
                    }
                }

                class ArrayIterator
                extends SuccessorIterator {
                    int i;

                    ArrayIterator(boolean atBegin) {
                        this.i = atBegin ? 0 : Array.getLength(Frame.this.obj);
                    }

                    boolean hasNext() {
                        return this.i < Array.getLength(Frame.this.obj);
                    }

                    boolean hasPrevious() {
                        return this.i > 0;
                    }

                    Object next() {
                        return Array.get(Frame.this.obj, this.i++);
                    }

                    Object previous() {
                        return Array.get(Frame.this.obj, --this.i);
                    }

                    TraversalGraph.NodeSet getTokens() {
                        return Frame.this.tokens;
                    }

                    void set(Object o) {
                        Array.set(Frame.this.obj, this.i, o);
                    }

                    protected ArrayIterator() {
                    }

                    public Object clone() {
                        ArrayIterator ret = new ArrayIterator();
                        ret.i = this.i;
                        return ret;
                    }

                    public boolean equals(Object o) {
                        return o instanceof ArrayIterator && ((ArrayIterator)o).i == this.i;
                    }

                    public String toString() {
                        return this.i + "";
                    }
                }

                abstract class SuccessorIterator
                implements Cloneable {
                    SuccessorIterator() {
                    }

                    abstract boolean hasNext();

                    abstract boolean hasPrevious();

                    abstract Object next();

                    abstract Object previous();

                    abstract TraversalGraph.NodeSet getTokens();

                    abstract void set(Object var1);

                    public abstract Object clone();
                }
            }
        }

        class Itr
        implements ListIterator {
            ConcurrentTraverser traverser;
            volatile Thread gatherThread;

            Itr() {
                this.traverser = new ConcurrentTraverser(APCollection.this.forward);
                this.gatherThread = new Thread(this){
                    private final /* synthetic */ Itr this$2;
                    {
                        this.this$2 = this$2;
                    }

                    public void run() {
                        ConcurrentTraverser concurrentTraverser = this.this$2.traverser;
                        synchronized (concurrentTraverser) {
                            this.this$2.traverser.traverse(APCollection.access$100((APCollection)Itr.access$200((Itr)this.this$2)).root, APCollection.access$100((APCollection)Itr.access$200((Itr)this.this$2)).startSet);
                            this.this$2.gatherThread = null;
                            this.this$2.traverser.notify();
                        }
                    }
                };
                this.gatherThread.setDaemon(true);
                ConcurrentTraverser concurrentTraverser = this.traverser;
                synchronized (concurrentTraverser) {
                    this.gatherThread.start();
                    try {
                        this.traverser.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e.toString());
                    }
                }
            }

            public boolean hasNext() {
                ConcurrentTraverser concurrentTraverser = this.traverser;
                synchronized (concurrentTraverser) {
                    boolean bl = this.gatherThread != null;
                    return bl;
                }
            }

            public Object next() {
                ConcurrentTraverser concurrentTraverser = this.traverser;
                synchronized (concurrentTraverser) {
                    Object ret = this.traverser.getReturnValue();
                    this.traverser.notify();
                    try {
                        this.traverser.wait();
                    }
                    catch (InterruptedException e) {
                        throw new RuntimeException(e.toString());
                    }
                    Object object = ret;
                    return object;
                }
            }

            public void set(Object o) {
                this.traverser.set(o);
            }

            UnsupportedOperationException bomb() {
                this.gatherThread.interrupt();
                return new UnsupportedOperationException();
            }

            public boolean hasPrevious() {
                throw this.bomb();
            }

            public Object previous() {
                throw this.bomb();
            }

            public void add(Object o) {
                throw this.bomb();
            }

            public void remove() {
                throw this.bomb();
            }

            public int nextIndex() {
                throw this.bomb();
            }

            public int previousIndex() {
                throw this.bomb();
            }

            static /* synthetic */ APCollection access$200(Itr x0) {
                return x0.APCollection.this;
            }
        }
    }

    class ConcurrentTraverser
    extends Traverser {
        Pointer pointer;
        Pointer returnValuePointer;

        ConcurrentTraverser(boolean f) {
            super(f);
        }

        void traverseArrayElement(Object o, int i, Class cl, TraversalGraph.NodeSet tokens) {
            this.pointer = new Pointer(this, o, i){
                private final /* synthetic */ Object val$o;
                private final /* synthetic */ int val$i;
                private final /* synthetic */ ConcurrentTraverser this$1;
                {
                    this.this$1 = this$1;
                    this.val$o = val$o;
                    this.val$i = val$i;
                }

                public void set(Object o2) {
                    Array.set(this.val$o, this.val$i, o2);
                }
            };
            super.traverseArrayElement(o, i, cl, tokens);
        }

        void traverseCollectionElement(ListIterator it, Object o, Class cl, TraversalGraph.NodeSet tokens, MutableFlag traversedCollection) {
            this.pointer = new Pointer(this, it){
                int i;
                private final /* synthetic */ ListIterator val$it;
                private final /* synthetic */ ConcurrentTraverser this$1;
                {
                    this.this$1 = this$1;
                    this.val$it = val$it;
                    this.i = this.val$it.nextIndex();
                }

                /*
                 * Handled impossible loop by adding 'first' condition
                 * Enabled aggressive block sorting
                 */
                public void set(Object o2) {
                    boolean bl;
                    boolean bl2;
                    int j = this.val$it.nextIndex();
                    boolean bl3 = true;
                    do {
                        if (!bl3 || (bl3 = false) || !true) {
                            if (this.this$1.forward) {
                                this.val$it.previous();
                            } else {
                                this.val$it.next();
                            }
                        }
                        if (this.this$1.forward) {
                            if (this.val$it.nextIndex() >= this.i) {
                                bl2 = true;
                                continue;
                            }
                            bl2 = false;
                            continue;
                        }
                        bl2 = this.val$it.nextIndex() <= this.i;
                    } while (bl2);
                    this.val$it.set(o2);
                    boolean bl4 = true;
                    do {
                        if (!bl4 || (bl4 = false) || !true) {
                            if (this.this$1.forward) {
                                this.val$it.next();
                            } else {
                                this.val$it.previous();
                            }
                        }
                        if (this.this$1.forward) {
                            if (this.val$it.nextIndex() >= j) return;
                            bl = true;
                            continue;
                        }
                        if (this.val$it.nextIndex() <= j) return;
                        bl = true;
                    } while (bl);
                }
            };
            super.traverseCollectionElement(it, o, cl, tokens, traversedCollection);
        }

        void traverseConstructionEdge(Object o, Class cl, EdgeI edge, Class targetClass, TraversalGraph.NodeSet tokens) {
            this.pointer = new Pointer(this, o, cl, edge){
                private final /* synthetic */ Object val$o;
                private final /* synthetic */ Class val$cl;
                private final /* synthetic */ EdgeI val$edge;
                private final /* synthetic */ ConcurrentTraverser this$1;
                {
                    this.this$1 = this$1;
                    this.val$o = val$o;
                    this.val$cl = val$cl;
                    this.val$edge = val$edge;
                }

                public void set(Object o2) {
                    ConcurrentTraverser.access$000(this.this$1).setTargetObject(this.val$o, this.val$cl, this.val$edge, o2);
                }
            };
            super.traverseConstructionEdge(o, cl, edge, targetClass, tokens);
        }

        void at(Object o, Class cl) {
            super.at(o, cl);
            this.returnValue = o;
            this.notify();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e.toString());
            }
            this.returnValuePointer = this.pointer;
        }

        void set(Object o) {
            this.returnValuePointer.set(o);
        }

        static /* synthetic */ ObjectGraphSlice access$000(ConcurrentTraverser x0) {
            return x0.ObjectGraphSlice.this;
        }

        abstract class Pointer {
            Pointer() {
            }

            abstract void set(Object var1);
        }
    }

    class Gatherer
    extends Traverser {
        Object last;

        Gatherer(boolean f) {
            super(f);
            this.returnValue = new ArrayList();
        }

        void at(Object o, Class cl) {
            if (o != this.last) {
                ((List)this.returnValue).add(o);
            }
            this.last = o;
            super.at(o, cl);
        }
    }

    class Fetcher
    extends Traverser {
        Fetcher() {
        }

        void at(Object o, Class cl) {
            this.returnValue = o;
            super.at(o, cl);
        }

        void traverseArray(Object o, Class cl, TraversalGraph.NodeSet tokens) {
            throw new FetchException("Cannot fetch through arrays: " + o.getClass());
        }

        void traverseEdges(Object o, Class cl, List edgeSets, boolean lastWasInheritance, MutableFlag traversedCollection) {
            if (edgeSets.size() > 1) {
                Iterator it = edgeSets.iterator();
                int i = 0;
                while (it.hasNext()) {
                    TraversalGraph.EdgeSet edgeSet = (TraversalGraph.EdgeSet)it.next();
                    if (!edgeSet.getEdge().isConstructionEdge() || i++ != 1) continue;
                    throw new FetchException("Non-unique path.");
                }
            }
            super.traverseEdges(o, cl, edgeSets, lastWasInheritance, traversedCollection);
        }

        void traverseCollection(Object o, Class nextClass, TraversalGraph.NodeSet nextTokens, MutableFlag traversedCollection) {
            throw new FetchException("Cannot fetch through collections: " + o.getClass());
        }
    }

    class VisitorTraverser
    extends Traverser {
        Visitor[] visitors;

        VisitorTraverser(Visitor[] v, boolean f) {
            super(f);
            this.visitors = v;
        }

        void before(Object o, Class cl) {
            int i = 0;
            while (i < this.visitors.length) {
                this.visitors[i].before(o, cl);
                ++i;
            }
        }

        void after(Object o, Class cl) {
            int i = this.visitors.length - 1;
            while (i >= 0) {
                this.visitors[i].after(o, cl);
                --i;
            }
        }

        Object getReturnValue() {
            return this.visitors[0].getReturnValue();
        }
    }

    abstract class Traverser {
        boolean forward = true;
        Object returnValue;

        Traverser() {
        }

        Traverser(boolean f) {
            this.forward = f;
        }

        Object traverse(Object o, TraversalGraph.NodeSet tokens) {
            this.traverseNode(o, ObjectGraphSlice.this.getTokensClass(tokens), tokens, false, new MutableFlag(false));
            return this.getReturnValue();
        }

        void traverseNode(Object o, Class nodeClass, TraversalGraph.NodeSet tokens, boolean lastWasInheritance, MutableFlag traversedCollection) {
            if (o == null) {
                if (ObjectGraphSlice.this.debug) {
                    System.out.println(o);
                }
                return;
            }
            Class<?> cl = o.getClass();
            ArrayList ancestors = null;
            if (ObjectGraphSlice.this.debug) {
                System.out.println("object type = " + cl + ", tokens = " + tokens);
            }
            if (cl.equals(nodeClass)) {
                ancestors = new ArrayList();
                this.addAncestors(cl, ancestors);
                this.before(o, ancestors);
            } else if (nodeClass.isPrimitive()) {
                this.before(o, nodeClass);
            }
            if (cl.isArray()) {
                this.traverseArray(o, nodeClass, tokens);
            } else {
                this.traverseEdges(o, nodeClass, tokens.getOutgoingEdgeSets(), lastWasInheritance, traversedCollection);
            }
            if (ancestors != null) {
                this.after(o, ancestors);
            } else if (nodeClass.isPrimitive()) {
                this.after(o, nodeClass);
            }
        }

        void addAncestors(Class cl, List l) {
            if (cl == null || l.contains(cl)) {
                return;
            }
            this.addAncestors(cl.getSuperclass(), l);
            Class<?>[] ifs = cl.getInterfaces();
            int i = 0;
            while (i < ifs.length) {
                this.addAncestors(ifs[i], l);
                ++i;
            }
            l.add(cl);
        }

        void before(Object o, List ancestors) {
            ListIterator it = ancestors.listIterator();
            while (it.hasNext()) {
                this.before(o, (Class)it.next());
            }
        }

        void before(Object o, Class cl) {
            if (this.forward && ObjectGraphSlice.this.isTargetClass(cl)) {
                this.at(o, cl);
            }
        }

        void after(Object o, List ancestors) {
            ListIterator it = ancestors.listIterator(ancestors.size());
            while (it.hasPrevious()) {
                this.after(o, (Class)it.previous());
            }
        }

        void after(Object o, Class cl) {
            if (!this.forward && ObjectGraphSlice.this.isTargetClass(cl)) {
                this.at(o, cl);
            }
        }

        void at(Object o, Class cl) {
            if (ObjectGraphSlice.this.debug) {
                System.out.println("at " + cl);
            }
        }

        /*
         * Handled impossible loop by adding 'first' condition
         * Enabled aggressive block sorting
         */
        void traverseArray(Object o, Class cl, TraversalGraph.NodeSet tokens) {
            boolean bl;
            int l = Array.getLength(o);
            int i = this.forward ? 0 : l - 1;
            boolean bl2 = true;
            do {
                if (!bl2 || (bl2 = false) || !true) {
                    this.traverseArrayElement(o, i, cl, tokens);
                    i = this.forward ? ++i : --i;
                }
                if (this.forward) {
                    if (i >= l) return;
                    bl = true;
                    continue;
                }
                if (i < 0) return;
                bl = true;
            } while (bl);
        }

        void traverseArrayElement(Object o, int i, Class cl, TraversalGraph.NodeSet tokens) {
            this.traverseNode(Array.get(o, i), cl, tokens, false, new MutableFlag(false));
        }

        void traverseEdges(Object o, Class cl, List edgeSets, boolean lastWasInheritance, MutableFlag traversedCollection) {
            int i = this.forward ? 0 : edgeSets.size();
            ListIterator it = edgeSets.listIterator(i);
            while (this.forward ? it.hasNext() : it.hasPrevious()) {
                TraversalGraph.EdgeSet edgeTokens = (TraversalGraph.EdgeSet)(this.forward ? it.next() : it.previous());
                this.traverseEdge(o, cl, edgeTokens, lastWasInheritance, traversedCollection);
            }
        }

        void traverseEdge(Object o, Class cl, TraversalGraph.EdgeSet tokens, boolean lastWasInheritance, MutableFlag traversedCollection) {
            TraversalGraph.NodeSet nextTokens = tokens.getTargetNodeSet();
            Class nextClass = ObjectGraphSlice.this.getTokensClass(nextTokens);
            EdgeI edge = tokens.getEdge();
            if (ObjectGraphSlice.this.debug) {
                System.out.println(edu.neu.ccs.demeter.aplib.TraversalGraph.edgeKey(edge));
            }
            if (lastWasInheritance || o.getClass().equals(cl)) {
                if (edge.isConstructionEdge()) {
                    if (ObjectGraphSlice.this.isRepetitionEdge(edge)) {
                        this.traverseCollection(o, nextClass, nextTokens, traversedCollection);
                    } else {
                        this.traverseConstructionEdge(o, cl, edge, nextClass, nextTokens);
                    }
                } else if (edge.isInheritanceEdge()) {
                    this.traverseSuperclass(o, nextClass, nextTokens, traversedCollection);
                }
            } else if (edge.isAlternationEdge() && !lastWasInheritance && nextClass.isInstance(o)) {
                this.traverseSubclass(o, nextClass, nextTokens, traversedCollection);
            }
        }

        void traverseCollection(Object o, Class nextClass, TraversalGraph.NodeSet nextTokens, MutableFlag traversedCollection) {
            if (!traversedCollection.flag) {
                traversedCollection.flag = true;
                ListIterator it = ObjectGraphSlice.getListIterator(o);
                while (this.forward ? it.hasNext() : it.hasPrevious()) {
                    this.traverseCollectionElement(it, this.forward ? it.next() : it.previous(), nextClass, nextTokens, traversedCollection);
                }
            }
        }

        void traverseCollectionElement(ListIterator it, Object o, Class cl, TraversalGraph.NodeSet tokens, MutableFlag traversedCollection) {
            this.traverseNode(o, cl, tokens, false, traversedCollection);
        }

        void traverseConstructionEdge(Object o, Class cl, EdgeI edge, Class targetClass, TraversalGraph.NodeSet tokens) {
            Object target = ObjectGraphSlice.this.getTargetObject(o, cl, edge);
            this.traverseNode(target, targetClass, tokens, false, new MutableFlag(false));
        }

        void traverseSubclass(Object o, Class subclass, TraversalGraph.NodeSet tokens, MutableFlag traversedCollection) {
            this.traverseNode(o, subclass, tokens, false, traversedCollection);
        }

        void traverseSuperclass(Object o, Class superclass, TraversalGraph.NodeSet tokens, MutableFlag traversedCollection) {
            this.traverseNode(o, superclass, tokens, true, traversedCollection);
        }

        Object getReturnValue() {
            return this.returnValue;
        }
    }

    class MutableFlag {
        boolean flag;

        MutableFlag(boolean f) {
            this.flag = f;
        }
    }
}

