/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.common.tg;

import edu.neu.ccs.demeter.common.tg.AEdge;
import edu.neu.ccs.demeter.common.tg.CEdge;
import edu.neu.ccs.demeter.common.tg.Edge;
import edu.neu.ccs.demeter.common.tg.IEdge;
import edu.neu.ccs.demeter.common.tg.NameI;
import edu.neu.ccs.demeter.common.tg.UniversalVisitor;
import edu.neu.ccs.demeter.common.tg.Vertex;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;

public class TraversalGraph {
    protected Dictionary vertices;
    protected Dictionary edges;

    public Dictionary get_vertices() {
        return this.vertices;
    }

    public void set_vertices(Dictionary new_vertices) {
        this.vertices = new_vertices;
    }

    public Dictionary get_edges() {
        return this.edges;
    }

    public void set_edges(Dictionary new_edges) {
        this.edges = new_edges;
    }

    public TraversalGraph(Dictionary vertices, Dictionary edges) {
        this.set_vertices(vertices);
        this.set_edges(edges);
    }

    public boolean hasVertex(NameI name) {
        return this.vertices.get(name) != null;
    }

    public Enumeration vertices() {
        return this.vertices.keys();
    }

    public boolean hasConstructionEdge(NameI source, NameI name, NameI dest) {
        return this.edges.get(CEdge.toString(source, name, dest)) != null;
    }

    public boolean hasAlternationEdge(NameI source, NameI dest) {
        return this.edges.get(AEdge.toString(source, dest)) != null;
    }

    public boolean hasInheritanceEdge(NameI source, NameI dest) {
        return this.edges.get(IEdge.toString(source, dest)) != null;
    }

    public Enumeration edges() {
        return this.edges.elements();
    }

    public String intercopyEdgesCode(NameI name, String indent, String setname) {
        Vertex v = (Vertex)this.vertices.get(name);
        return v.intercopyEdgesCode(indent, setname);
    }

    public String cedgeMaskCode(NameI source, NameI name, NameI dest, String indent, String oldsetname, String newsetname) {
        CEdge cedge = (CEdge)this.edges.get(CEdge.toString(source, name, dest));
        return cedge.maskCode(indent, oldsetname, newsetname);
    }

    public String iedgeMaskCode(NameI source, NameI dest, String indent, String oldsetname, String newsetname) {
        IEdge iedge = (IEdge)this.edges.get(IEdge.toString(source, dest));
        return iedge.maskCode(indent, oldsetname, newsetname);
    }

    public TraversalGraph() {
        this.vertices = new Hashtable();
        this.edges = new Hashtable();
    }

    void add(Vertex v) {
        this.vertices.put(v.get_name(), v);
    }

    void add(Edge e) {
        this.edges.put(e.toString(), e);
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        _v_.before_vertices(this, this.vertices);
        _v_.after_vertices(this, this.vertices);
        _v_.before_edges(this, this.edges);
        _v_.after_edges(this, this.edges);
        this.universal_trv0_aft(_v_);
    }
}

