/*
 * Decompiled with CFR 0.152.
 */
package edu.neu.ccs.demeter.aplib.cd;

import edu.neu.ccs.demeter.aplib.ClassGraphI;
import edu.neu.ccs.demeter.aplib.EdgeI;
import edu.neu.ccs.demeter.aplib.NoSuchClassGraphNodeException;
import edu.neu.ccs.demeter.aplib.TraversalGraph;
import edu.neu.ccs.demeter.aplib.cd.AlternationClass;
import edu.neu.ccs.demeter.aplib.cd.ClassDef;
import edu.neu.ccs.demeter.aplib.cd.ClassDefVisitor;
import edu.neu.ccs.demeter.aplib.cd.ClassGraphEntry;
import edu.neu.ccs.demeter.aplib.cd.ClassGraphEntry_SList;
import edu.neu.ccs.demeter.aplib.cd.ClassName;
import edu.neu.ccs.demeter.aplib.cd.ConstructionClass;
import edu.neu.ccs.demeter.aplib.cd.Interface;
import edu.neu.ccs.demeter.aplib.cd.ParseException;
import edu.neu.ccs.demeter.aplib.cd.Parser;
import edu.neu.ccs.demeter.aplib.cd.Part;
import edu.neu.ccs.demeter.aplib.cd.PartVisitor;
import edu.neu.ccs.demeter.aplib.cd.Preamble;
import edu.neu.ccs.demeter.aplib.cd.PrintVisitor;
import edu.neu.ccs.demeter.aplib.cd.Subclass;
import edu.neu.ccs.demeter.aplib.cd.Superclass;
import edu.neu.ccs.demeter.aplib.cd.UniversalVisitor;
import edu.neu.ccs.demeter.aplib.cd.__V_ClassGraph_buildClassDefTable;
import edu.neu.ccs.demeter.aplib.cd.__V_ClassGraph_convertRepetition;
import edu.neu.ccs.demeter.aplib.cd.__V_ClassGraph_expandParamDefs;
import edu.neu.ccs.demeter.aplib.cd.__V_ClassGraph_fillInPartNames;
import edu.neu.ccs.demeter.aplib.cd.__V_ClassGraph_removeParamDefs;
import edu.neu.ccs.demeter.aplib.cd.__V_ClassGraph_setBackLinks;
import edu.neu.ccs.demeter.aplib.cd.__V_ClassGraph_setInheritanceLinks;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ClassGraph
implements ClassGraphI,
Cloneable {
    protected Preamble preamble;
    protected ClassGraphEntry_SList classes;
    Map repdict;
    Map defmap = new HashMap();
    List classnames = new ArrayList();

    public Preamble get_preamble() {
        return this.preamble;
    }

    public void set_preamble(Preamble new_preamble) {
        this.preamble = new_preamble;
    }

    public ClassGraphEntry_SList get_classes() {
        return this.classes;
    }

    public void set_classes(ClassGraphEntry_SList new_classes) {
        this.classes = new_classes;
    }

    public ClassGraph() {
    }

    public ClassGraph(Preamble preamble, ClassGraphEntry_SList classes) {
        this.set_preamble(preamble);
        this.set_classes(classes);
    }

    public static ClassGraph parse(Reader in) throws ParseException {
        return new Parser(in)._ClassGraph();
    }

    public static ClassGraph parse(InputStream in) throws ParseException {
        return new Parser(in)._ClassGraph();
    }

    public static ClassGraph parse(String s) {
        try {
            return ClassGraph.parse(new StringReader(s));
        }
        catch (ParseException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public static ClassGraph readFrom(InputStream in) throws ParseException {
        return ClassGraph.parse(in).normalize();
    }

    public static ClassGraph fromString(String s) {
        return ClassGraph.parse(s).normalize();
    }

    public ClassGraph normalize() {
        this.buildClassDefTable();
        ClassGraph cg = this.expandParamDefs();
        cg.convertRepetition();
        cg.fillInPartNames();
        cg.setInheritanceLinks();
        cg.setBackLinks();
        return cg;
    }

    ClassDef findOrAddClassDef(String l) {
        ClassDef def = this.findClassDef(l);
        if (def == null) {
            def = ClassDef.parse("foo = .");
            def.set_classname(ClassName.parse(l));
            this.addClassDef(def);
        }
        return def;
    }

    public Part addConstructionEdge(String source, String name, String target) {
        ClassDef srcdef = this.findOrAddClassDef(source);
        ClassDef targetdef = this.findOrAddClassDef(target);
        Part edge = Part.parse("<" + name + "> " + target);
        edge.def = srcdef;
        srcdef.addPart(edge);
        srcdef.addOutgoingEdge(edge);
        targetdef.addIncomingEdge(edge);
        return edge;
    }

    public Subclass addAlternationEdge(String source, String target) {
        ClassDef srcdef = this.findOrAddClassDef(source);
        if (srcdef.isConstructionClass()) {
            ConstructionClass cc = (ConstructionClass)srcdef.get_classparts();
            AlternationClass ac = AlternationClass.parse(": common");
            ac.set_parts(cc.get_parts());
            ac.set_parents(cc.get_parents());
            srcdef.set_classparts(ac);
        }
        ClassDef targetdef = this.findOrAddClassDef(target);
        Subclass edge = Subclass.parse(target);
        edge.def = srcdef;
        srcdef.addAlternation(edge);
        srcdef.addOutgoingEdge(edge);
        targetdef.addIncomingEdge(edge);
        return edge;
    }

    public EdgeI addInheritanceEdge(String source, String target) {
        EdgeI edge;
        ClassDef srcdef = this.findOrAddClassDef(source);
        ClassDef targetdef = this.findOrAddClassDef(target);
        if (srcdef.isInterface() || srcdef.get_superclass_name() == null) {
            Superclass sup = Superclass.parse(target);
            sup.def = srcdef;
            srcdef.addSuperclass(sup);
            edge = sup;
        } else {
            Interface inf = Interface.parse(target);
            inf.def = srcdef;
            srcdef.addInterface(inf);
            edge = inf;
        }
        srcdef.addOutgoingEdge(edge);
        targetdef.addIncomingEdge(edge);
        return edge;
    }

    public EdgeI addEdge(EdgeI edge) {
        EdgeI ret;
        String source = edge.getSource().toString();
        String target = edge.getTarget().toString();
        if (edge.isConstructionEdge()) {
            ret = this.addConstructionEdge(source, edge.getLabel(), target);
        } else if (edge.isAlternationEdge()) {
            ret = this.addAlternationEdge(source, target);
        } else if (edge.isInheritanceEdge()) {
            ret = this.addInheritanceEdge(source, target);
        } else {
            throw new RuntimeException("Unknown edge type: " + edge);
        }
        return ret;
    }

    public void printTraversalEdges(TraversalGraph tg, PrintWriter out) {
        Iterator nodes = tg.getNodeSets().iterator();
        while (nodes.hasNext()) {
            ((ClassDef)((TraversalGraph.NodeSet)nodes.next()).getNode()).printTraversalEdges(tg, out);
        }
    }

    public Collection getNodes() {
        return Collections.unmodifiableCollection(this.defmap.values());
    }

    public Object getNode(String l) throws NoSuchClassGraphNodeException {
        ClassDef def = this.findClassDef(l);
        if (def == null) {
            throw new NoSuchClassGraphNodeException((Object)l);
        }
        return def;
    }

    public Collection getOutgoingEdges(Object v) throws NoSuchClassGraphNodeException {
        if (v == null) {
            throw new NoSuchClassGraphNodeException(v);
        }
        return Collections.unmodifiableCollection(((ClassDef)v).getOutgoingEdges());
    }

    public Collection getIncomingEdges(Object v) throws NoSuchClassGraphNodeException {
        if (v == null) {
            throw new NoSuchClassGraphNodeException(v);
        }
        return Collections.unmodifiableCollection(((ClassDef)v).getIncomingEdges());
    }

    ClassGraph expandParamDefs() {
        __V_ClassGraph_expandParamDefs v0 = new __V_ClassGraph_expandParamDefs();
        v0.start();
        this.__trav_expandParamDefs(v0);
        v0.finish();
        return v0.get_return_val();
    }

    ClassGraph removeParamDefs() {
        __V_ClassGraph_removeParamDefs v0 = new __V_ClassGraph_removeParamDefs();
        v0.start();
        this.__trav_removeParamDefs(v0);
        v0.finish();
        return v0.get_return_val();
    }

    void convertRepetition() {
        __V_ClassGraph_convertRepetition v0 = new __V_ClassGraph_convertRepetition();
        v0.start();
        this.__trav_convertRepetition(v0);
        v0.finish();
    }

    void fillInPartNames() {
        __V_ClassGraph_fillInPartNames v0 = new __V_ClassGraph_fillInPartNames();
        v0.start();
        this.allParts(v0);
        v0.finish();
    }

    void setInheritanceLinks() {
        __V_ClassGraph_setInheritanceLinks v0 = new __V_ClassGraph_setInheritanceLinks();
        v0.start();
        this.__trav_setInheritanceLinks(v0);
        v0.finish();
    }

    void setBackLinks() {
        __V_ClassGraph_setBackLinks v0 = new __V_ClassGraph_setBackLinks();
        v0.start();
        this.__trav_setBackLinks(v0);
        v0.finish();
    }

    void buildClassDefTable() {
        __V_ClassGraph_buildClassDefTable v0 = new __V_ClassGraph_buildClassDefTable();
        v0.start();
        this.allClassDefs(v0);
        v0.finish();
    }

    ClassDef findClassDef(ClassName name) {
        return this.findClassDef(name.toString());
    }

    ClassDef findClassDef(String name) {
        return (ClassDef)this.defmap.get(name);
    }

    boolean definesClass(ClassName name) {
        return this.definesClass(name.toString());
    }

    public boolean definesClass(String name) {
        return this.defmap.containsKey(name);
    }

    void addClassGraphEntry(ClassGraphEntry cge) {
        if (this.classes == null) {
            this.classes = new ClassGraphEntry_SList();
        }
        this.classes.addElement(cge);
    }

    void addClassDef(ClassDef def) {
        String name = def.get_classname().toString();
        this.defmap.put(name, def);
        this.classnames.add(name);
        def.set_cg(this);
        this.addClassGraphEntry(def);
    }

    List getClassNames() {
        return this.classnames;
    }

    public String toString() {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        this.universal_trv0(new PrintVisitor(pw));
        pw.flush();
        return w.toString();
    }

    void universal_trv0_bef(UniversalVisitor _v_) {
        _v_.before(this);
    }

    void universal_trv0_aft(UniversalVisitor _v_) {
        _v_.after(this);
    }

    void universal_trv0(UniversalVisitor _v_) {
        this.universal_trv0_bef(_v_);
        if (this.preamble != null) {
            _v_.before_preamble(this, this.preamble);
            this.preamble.universal_trv0(_v_);
            _v_.after_preamble(this, this.preamble);
        }
        if (this.classes != null) {
            _v_.before_classes(this, this.classes);
            this.classes.universal_trv0(_v_);
            _v_.after_classes(this, this.classes);
        }
        this.universal_trv0_aft(_v_);
    }

    public void allClassDefs(ClassDefVisitor v) {
        this.allClassDefs_ClassGraph_trv(v);
    }

    void allClassDefs_ClassGraph_trv_bef(ClassDefVisitor v) {
        v.before(this);
    }

    void allClassDefs_ClassGraph_trv_aft(ClassDefVisitor v) {
        v.after(this);
    }

    void allClassDefs_ClassGraph_trv(ClassDefVisitor v) {
        this.allClassDefs_ClassGraph_trv_bef(v);
        if (this.classes != null) {
            v.before_classes(this, this.classes);
            this.classes.allClassDefs_ClassGraph_trv(v);
            v.after_classes(this, this.classes);
        }
        this.allClassDefs_ClassGraph_trv_aft(v);
    }

    public void allParts(PartVisitor v) {
        this.allParts_ClassGraph_trv(v);
    }

    void allParts_ClassGraph_trv_bef(PartVisitor v) {
        v.before(this);
    }

    void allParts_ClassGraph_trv_aft(PartVisitor v) {
        v.after(this);
    }

    void allParts_ClassGraph_trv(PartVisitor v) {
        this.allParts_ClassGraph_trv_bef(v);
        if (this.classes != null) {
            v.before_classes(this, this.classes);
            this.classes.allParts_ClassGraph_trv(v);
            v.after_classes(this, this.classes);
        }
        this.allParts_ClassGraph_trv_aft(v);
    }

    public void __trav_expandParamDefs(__V_ClassGraph_expandParamDefs __v0) {
        this.__trav_expandParamDefs_ClassGraph_trv(__v0);
    }

    void __trav_expandParamDefs_ClassGraph_trv_bef(__V_ClassGraph_expandParamDefs __v0) {
        __v0.before(this);
    }

    void __trav_expandParamDefs_ClassGraph_trv_aft(__V_ClassGraph_expandParamDefs __v0) {
        __v0.after(this);
    }

    void __trav_expandParamDefs_ClassGraph_trv(__V_ClassGraph_expandParamDefs __v0) {
        this.__trav_expandParamDefs_ClassGraph_trv_bef(__v0);
        if (this.classes != null) {
            this.classes.__trav_expandParamDefs_ClassGraph_trv(__v0);
        }
        this.__trav_expandParamDefs_ClassGraph_trv_aft(__v0);
    }

    public void __trav_removeParamDefs(__V_ClassGraph_removeParamDefs __v0) {
        this.__trav_removeParamDefs_ClassGraph_trv(__v0);
    }

    void __trav_removeParamDefs_ClassGraph_trv_bef(__V_ClassGraph_removeParamDefs __v0) {
    }

    void __trav_removeParamDefs_ClassGraph_trv_aft(__V_ClassGraph_removeParamDefs __v0) {
    }

    void __trav_removeParamDefs_ClassGraph_trv(__V_ClassGraph_removeParamDefs __v0) {
        this.__trav_removeParamDefs_ClassGraph_trv_bef(__v0);
        if (this.classes != null) {
            this.classes.__trav_removeParamDefs_ClassGraph_trv(__v0);
        }
        this.__trav_removeParamDefs_ClassGraph_trv_aft(__v0);
    }

    public void __trav_convertRepetition(__V_ClassGraph_convertRepetition __v0) {
        BitSet startSet = new BitSet();
        startSet.set(0);
        this.__trav_convertRepetition_ClassGraph_trv(startSet, __v0);
    }

    void __trav_convertRepetition_ClassGraph_trv_bef(__V_ClassGraph_convertRepetition __v0) {
        __v0.before(this);
    }

    void __trav_convertRepetition_ClassGraph_trv_aft(__V_ClassGraph_convertRepetition __v0) {
        __v0.after(this);
    }

    void __trav_convertRepetition_ClassGraph_trv(BitSet nodes, __V_ClassGraph_convertRepetition __v0) {
        this.__trav_convertRepetition_ClassGraph_trv_bef(__v0);
        if (this.classes != null) {
            BitSet newnodes = new BitSet();
            newnodes.set(0);
            newnodes.and(nodes);
            if (!newnodes.equals(new BitSet())) {
                this.classes.__trav_convertRepetition_ClassGraph_trv(newnodes, __v0);
            }
        }
        this.__trav_convertRepetition_ClassGraph_trv_aft(__v0);
    }

    public void __trav_setInheritanceLinks(__V_ClassGraph_setInheritanceLinks __v0) {
        this.__trav_setInheritanceLinks_ClassGraph_trv(__v0);
    }

    void __trav_setInheritanceLinks_ClassGraph_trv_bef(__V_ClassGraph_setInheritanceLinks __v0) {
        __v0.before(this);
    }

    void __trav_setInheritanceLinks_ClassGraph_trv_aft(__V_ClassGraph_setInheritanceLinks __v0) {
    }

    void __trav_setInheritanceLinks_ClassGraph_trv(__V_ClassGraph_setInheritanceLinks __v0) {
        this.__trav_setInheritanceLinks_ClassGraph_trv_bef(__v0);
        if (this.classes != null) {
            this.classes.__trav_setInheritanceLinks_ClassGraph_trv(__v0);
        }
        this.__trav_setInheritanceLinks_ClassGraph_trv_aft(__v0);
    }

    public void __trav_setBackLinks(__V_ClassGraph_setBackLinks __v0) {
        this.__trav_setBackLinks_ClassGraph_trv(__v0);
    }

    void __trav_setBackLinks_ClassGraph_trv_bef(__V_ClassGraph_setBackLinks __v0) {
        __v0.before(this);
    }

    void __trav_setBackLinks_ClassGraph_trv_aft(__V_ClassGraph_setBackLinks __v0) {
    }

    void __trav_setBackLinks_ClassGraph_trv(__V_ClassGraph_setBackLinks __v0) {
        this.__trav_setBackLinks_ClassGraph_trv_bef(__v0);
        if (this.classes != null) {
            this.classes.__trav_setBackLinks_ClassGraph_trv(__v0);
        }
        this.__trav_setBackLinks_ClassGraph_trv_aft(__v0);
    }
}

